/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.rendering;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.inform.api.batching.Batch;
import com.atlassian.jira.plugins.inform.api.batching.rendering.ContextProvider;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nHelperBeanFactory;
    private static final Function<String, String> escape = text -> StringEscapeUtils.escapeHtml4((String)text);

    @Autowired
    public DefaultContextProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport I18nHelper.BeanFactory i18nHelperBeanFactory) {
        this.applicationProperties = applicationProperties;
        this.i18nHelperBeanFactory = i18nHelperBeanFactory;
    }

    public Map<String, Object> createContext(Batch batch, ContextProvider.ContextParameters contextParameters) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        builder.put((Object)"batch", (Object)batch);
        builder.put((Object)"baseurl", (Object)baseUrl);
        builder.put((Object)"i18n", (Object)this.i18nHelperBeanFactory.getInstance(batch.getRecipient().getUser()));
        builder.put((Object)"escape", escape);
        return builder.build();
    }

    public boolean batcherSupported(String batcherName) {
        return true;
    }
}

