/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients.filters;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.IssueEventNotificationFilterContext;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilter;
import com.atlassian.jira.notification.NotificationFilterContext;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.plugins.inform.api.batching.BatcherService;
import com.atlassian.jira.plugins.inform.api.batching.BatchingConfiguration;
import com.atlassian.jira.plugins.inform.api.batching.BatchingType;
import com.atlassian.jira.plugins.inform.api.batching.UserPreferencesService;
import com.atlassian.jira.plugins.inform.api.events.convert.RecipientProvider;
import com.atlassian.jira.plugins.inform.events.listener.internal.EventSplitter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BatchingNotificationFilter
implements NotificationFilter {
    private final BatcherService batcherService;
    private final UserPreferencesService userPreferencesService;
    private final RecipientProvider recipientProvider;
    private final EventSplitter eventSplitter;

    @Autowired
    public BatchingNotificationFilter(BatcherService batcherService, UserPreferencesService userPreferencesService, @Qualifier(value="jiraRecipientProvider") RecipientProvider recipientProvider, @ComponentImport EventSplitter eventSplitter) {
        this.batcherService = batcherService;
        this.userPreferencesService = userPreferencesService;
        this.recipientProvider = recipientProvider;
        this.eventSplitter = eventSplitter;
    }

    public Iterable<NotificationRecipient> addRecipient(NotificationFilterContext notificationFilterContext, Iterable<NotificationRecipient> iterable) {
        return Collections.emptyList();
    }

    public boolean removeRecipient(NotificationRecipient notificationRecipient, NotificationFilterContext notificationFilterContext) {
        if (notificationFilterContext instanceof IssueEventNotificationFilterContext) {
            IssueEventNotificationFilterContext context = (IssueEventNotificationFilterContext)notificationFilterContext;
            IssueEvent issueEvent = context.getIssueEvent();
            if (this.batcherService.someBatcherSupportsEvent(issueEvent) && this.userPreferencesService.getConfiguration(notificationRecipient.getUser()).getBatchingType() != BatchingType.OFF && this.mailEventRecipientProviderHandlesRecipient(issueEvent, notificationRecipient)) {
                return true;
            }
        } else if (notificationFilterContext.getReason() == JiraNotificationReason.MENTIONED) {
            BatchingConfiguration configuration = this.userPreferencesService.getConfiguration(notificationRecipient.getUser());
            return configuration.getBatchingType() != BatchingType.OFF && configuration.isSendMentionsImmediately();
        }
        return false;
    }

    private boolean mailEventRecipientProviderHandlesRecipient(IssueEvent issueEvent, NotificationRecipient notificationRecipient) {
        if (issueEvent == null || notificationRecipient == null) {
            return false;
        }
        return this.eventSplitter.splitEvent(issueEvent).anyMatch(event -> this.recipientProvider.isRecipientForEvent(event, notificationRecipient.getUser()));
    }
}

