/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.recipients;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.plugins.inform.api.batching.UserPreferencesService;
import com.atlassian.jira.plugins.inform.api.events.EventConsumer;
import com.atlassian.jira.plugins.inform.api.events.EventStatus;
import com.atlassian.jira.plugins.inform.api.events.MailLoggerFactory;
import com.atlassian.jira.plugins.inform.api.events.Recipient;
import com.atlassian.jira.plugins.inform.api.events.convert.RecipientProvider;
import com.atlassian.jira.plugins.inform.api.events.dto.RecipientDTO;
import com.atlassian.jira.plugins.inform.batching.recipients.MentionedRecipientRetriever;
import com.atlassian.jira.plugins.inform.batching.recipients.RecipientFilterer;
import com.atlassian.jira.plugins.inform.batching.recipients.RecipientRetriever;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="jiraRecipientProvider")
@ReturnValuesAreNonnullByDefault
public class JiraNotificationSchemeRecipientProvider
implements RecipientProvider {
    private static final Logger LOG = MailLoggerFactory.getOutgoingMailLogger(JiraNotificationSchemeRecipientProvider.class);
    private final UserPreferencesService userPreferencesService;
    private final EventConsumer mailEventConsumer;
    private final Clock clock;
    private final FeatureManager featureManager;
    private final MentionedRecipientRetriever mentionedRecipientRetriever;
    private final RecipientRetriever recipientRetriever;
    private final RecipientFilterer recipientFilterer;
    private final LoadingCache<IssueEvent, Recipients> resultCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumWeight(1000000L).weigher((key, recipients) -> recipients.totalCount()).build(JiraNotificationSchemeRecipientProvider.loader(this::getRecipientsImpl));

    @Autowired
    public JiraNotificationSchemeRecipientProvider(UserPreferencesService userPreferencesService, EventConsumer mailEventConsumer, @ComponentImport FeatureManager featureManager, MentionedRecipientRetriever mentionedRecipientRetriever, RecipientRetriever recipientRetriever, RecipientFilterer recipientFilterer) {
        this(userPreferencesService, mailEventConsumer, Clock.systemUTC(), featureManager, mentionedRecipientRetriever, recipientRetriever, recipientFilterer);
    }

    @VisibleForTesting
    JiraNotificationSchemeRecipientProvider(UserPreferencesService userPreferencesService, EventConsumer mailEventConsumer, Clock clock, FeatureManager featureManager, MentionedRecipientRetriever mentionedRecipientRetriever, RecipientRetriever recipientRetriever, RecipientFilterer recipientFilterer) {
        this.userPreferencesService = userPreferencesService;
        this.mailEventConsumer = mailEventConsumer;
        this.clock = clock;
        this.featureManager = featureManager;
        this.mentionedRecipientRetriever = mentionedRecipientRetriever;
        this.recipientRetriever = recipientRetriever;
        this.recipientFilterer = recipientFilterer;
    }

    public Collection<Recipient> getRecipients(IssueEvent issueEvent) {
        if (!this.featureManager.isEnabled(JiraInformFeatureFlags.MAIL_BATCHING) || !issueEvent.isSendMail()) {
            return ImmutableList.of();
        }
        LOG.debug("Getting recipients for " + issueEvent);
        Recipients recipients = (Recipients)this.resultCache.getUnchecked((Object)issueEvent);
        Instant now = Instant.now(this.clock);
        Stream<RecipientDTO> mentionedUsersStream = recipients.mentioned.stream().map(user -> new RecipientDTO(null, user.getKey(), this.getEventConsumer().getName(), EventStatus.NEW, now, null, now));
        Stream<RecipientDTO> notMentionedUsersStream = recipients.unmentioned.stream().map(user -> new RecipientDTO(null, user.getKey(), this.getEventConsumer().getName(), EventStatus.NEW, now, null, this.getNextSendDate((ApplicationUser)user)));
        List<Recipient> recipientsList = Stream.concat(mentionedUsersStream, notMentionedUsersStream).collect(Collectors.toList());
        LOG.debug("Recipients: {}", recipientsList);
        return recipientsList;
    }

    public boolean isRecipientForEvent(IssueEvent issueEvent, ApplicationUser user) {
        return ((Recipients)this.resultCache.getUnchecked((Object)issueEvent)).contains(user);
    }

    public EventConsumer getEventConsumer() {
        return this.mailEventConsumer;
    }

    private Recipients getRecipientsImpl(IssueEvent issueEvent) {
        Set allRecipients = this.recipientRetriever.get(issueEvent).filter(user -> this.recipientFilterer.shouldPass(issueEvent, (ApplicationUser)user)).collect(Collectors.toSet());
        Set<ApplicationUser> mentionedRecipients = this.mentionedRecipientRetriever.get(issueEvent).filter(user -> this.recipientFilterer.shouldPass(issueEvent, (ApplicationUser)user)).collect(Collectors.toSet());
        Sets.SetView unmentionedRecipients = Sets.difference(allRecipients, mentionedRecipients);
        return new Recipients(mentionedRecipients, (Set<ApplicationUser>)unmentionedRecipients);
    }

    private Instant getNextSendDate(ApplicationUser user) {
        return this.userPreferencesService.getNextNotificationTime(user);
    }

    private static <K, V> CacheLoader<K, V> loader(final Function<K, V> source) {
        return new CacheLoader<K, V>(){

            public V load(@Nonnull K key) {
                return source.apply(key);
            }
        };
    }

    @ParametersAreNonnullByDefault
    private static class Recipients {
        final Set<ApplicationUser> mentioned;
        final Set<ApplicationUser> unmentioned;

        Recipients(Set<ApplicationUser> mentioned, Set<ApplicationUser> unmentioned) {
            this.mentioned = Objects.requireNonNull(mentioned);
            this.unmentioned = Objects.requireNonNull(unmentioned);
        }

        static Recipients empty() {
            return new Recipients((Set<ApplicationUser>)ImmutableSet.of(), (Set<ApplicationUser>)ImmutableSet.of());
        }

        public int totalCount() {
            return this.mentioned.size() + this.unmentioned.size();
        }

        public boolean contains(ApplicationUser user) {
            return this.mentioned.contains(user) || this.unmentioned.contains(user);
        }
    }
}

