/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.configuration;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugins.inform.api.batching.InstancePreferencesService;
import com.atlassian.jira.plugins.inform.flags.JiraInformFeatureFlags;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class ConfigureBatchingAction
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ConfigureBatchingAction.class);
    private final PageBuilderService pageBuilderService;
    private final HelpUrls helpUrls;
    private final FeatureManager featureManager;
    private final InstancePreferencesService instancePreferencesService;

    public ConfigureBatchingAction(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport HelpUrls helpUrls, @ComponentImport FeatureManager featureManager, InstancePreferencesService instancePreferencesService) {
        this.pageBuilderService = pageBuilderService;
        this.helpUrls = helpUrls;
        this.featureManager = featureManager;
        this.instancePreferencesService = instancePreferencesService;
    }

    public String doDefault() throws Exception {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.plugins.inform.batching-plugin:batching-configuration");
        return "input";
    }

    @ActionViewData
    public boolean getCurrentBatchingState() {
        return this.featureManager.isEnabled(JiraInformFeatureFlags.MAIL_BATCHING);
    }

    @ActionViewData
    public int getCurrentInterval() {
        return this.instancePreferencesService.getBatchingType().getValue();
    }

    @ActionViewData
    public ViewHelpUrl getHelpUrl() {
        return new ViewHelpUrl(this.helpUrls.getUrl("batching.configuration"));
    }

    @ActionViewData
    public String getBatchingSwitchFeatureFlag() {
        return JiraInformFeatureFlags.MAIL_BATCHING.featureKey();
    }

    public static class ViewHelpUrl {
        private final String url;
        private final String title;

        public ViewHelpUrl(HelpUrl url) {
            this.url = url.getUrl();
            this.title = url.getTitle();
        }

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

