/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.clustersafe;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import com.atlassian.jira.service.AbstractService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSvnIndexService
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSvnIndexService.class);
    public static final String SERVICE_NAME = "Subversion Index Update Service";
    private MultipleSubversionRepositoryManager multipleSubversionRepositoryManager = (MultipleSubversionRepositoryManager)ComponentAccessor.getOSGiComponentInstanceOfType(MultipleSubversionRepositoryManager.class);

    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("Indexing job started at {}", (Object)new Date());
        }
        try {
            RevisionIndexer revisionIndexer = this.multipleSubversionRepositoryManager.getRevisionIndexer();
            if (revisionIndexer != null) {
                revisionIndexer.updateIndex();
            } else {
                logger.warn("Tried to index changes but SubversionManager has no revision indexer.");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while indexing changes: " + e);
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("svnupdateservice", "com/atlassian/jira/plugin/ext/subversion/action/UpdateSvnIndexService.xml", null);
    }

    public static String getServiceName() {
        return SERVICE_NAME;
    }
}

