/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.clustersafe;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.clustersafe.UpdateSvnIndexService;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SchedulerLauncher
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerLauncher.class);
    static final String PLUGIN_KEY = "com.atlassian.jira.plugin.ext.subversion";
    private static final long DEFAULT_SERVICE_DELAY = TimeUnit.HOURS.toMillis(1L);
    private final EventPublisher eventPublisher;
    private final ServiceManager serviceManager;
    private final JiraPropertySetFactory propertySetFactory;
    @GuardedBy(value="this")
    private final Set<LifecycleEvent> lifecycleEvents = EnumSet.noneOf(LifecycleEvent.class);

    public SchedulerLauncher(EventPublisher eventPublisher, ServiceManager serviceManager, JiraPropertySetFactory jiraPropertySetFactory) {
        this.eventPublisher = eventPublisher;
        this.serviceManager = serviceManager;
        this.propertySetFactory = jiraPropertySetFactory;
    }

    public void afterPropertiesSet() {
        this.registerListener();
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    public void destroy() throws Exception {
        this.unregisterListener();
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        if (this.isLifecycleReady(event)) {
            this.unregisterListener();
            try {
                this.registerService();
            }
            catch (Exception ex) {
                logger.error("Unexpected error when starting JIRA SVN plugin.", (Throwable)ex);
            }
        }
    }

    private synchronized boolean isLifecycleReady(LifecycleEvent event) {
        return this.lifecycleEvents.add(event) && this.lifecycleEvents.size() == LifecycleEvent.values().length;
    }

    private void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    private void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    private void registerService() {
        try {
            if (this.serviceManager.getServiceWithName("Subversion Index Update Service") == null) {
                this.serviceManager.addService("Subversion Index Update Service", UpdateSvnIndexService.class, DEFAULT_SERVICE_DELAY);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Service Subversion Index Update Service registered");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register service: Subversion Index Update Service", ex);
        }
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

