/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions;

import com.atlassian.jira.plugin.ext.subversion.revisions.LuceneIndexAccessor;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultLuceneIndexAccessor
implements LuceneIndexAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLuceneIndexAccessor.class);

    DefaultLuceneIndexAccessor() {
    }

    @Override
    public IndexReader getIndexReader(String path) throws IOException {
        return IndexReader.open((Directory)this.getDirectory(path));
    }

    private Directory getDirectory(String path) throws IOException {
        return FSDirectory.open((File)new File(path), (LockFactory)new SimpleFSLockFactory());
    }

    @Override
    public IndexWriter getIndexWriter(String path, boolean create, Analyzer analyzer) throws IOException {
        try {
            DefaultLuceneIndexAccessor.createDirRobust(path);
            IndexWriter indexWriter = new IndexWriter(this.getDirectory(path), analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
            indexWriter.setUseCompoundFile(true);
            return indexWriter;
        }
        catch (IOException e) {
            LOG.error("Problem with path " + path + ": " + e.getMessage(), (Throwable)e);
            throw new IOException("Problem with path " + path + ": " + e.getMessage(), e);
        }
    }

    private static void createDirRobust(String path) throws IOException {
        File potentialPath = new File(path);
        if (!potentialPath.exists()) {
            LOG.warn("Directory " + path + " does not exist - perhaps it was deleted?  Creating..");
            boolean created = potentialPath.mkdirs();
            if (!created) {
                LOG.warn("Directory " + path + " could not be created.  Aborting index creation");
                throw new IOException("Could not create directory: " + path);
            }
        }
        if (!potentialPath.isDirectory()) {
            LOG.warn("File " + path + " is not a directory.  Cannot create index");
            throw new IOException("File " + path + " is not a directory.  Cannot create index");
        }
        if (!potentialPath.canWrite()) {
            LOG.warn("Dir " + path + " is not writable.  Cannot create index");
            throw new IOException("Dir " + path + " is not writable.  Cannot create index");
        }
    }
}

