/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.projecttabpanels;

import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.projecttabpanels.SubversionProjectRevisionAction;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.impl.GenericProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.web.bean.I18nBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNLogEntry;
import webwork.action.ActionContext;

public class SubversionProjectTabPanel
extends GenericProjectTabPanel
implements ProjectTabPanel {
    private static final Logger log = LoggerFactory.getLogger(SubversionProjectTabPanel.class);
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final BuildUtilsInfo buildUtilsInfo;
    public static final int ALL_VERSIONS = -1;
    public static final int NUMBER_OF_REVISIONS = 100;
    public static final boolean INCLUDE_ARCHIVED_VERSIONS = false;

    public SubversionProjectTabPanel(JiraAuthenticationContext authenticationContext, MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, VersionManager versionManager, PermissionManager permissionManager, BuildUtilsInfo buildUtilsInfo) {
        super(authenticationContext);
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public String getHtml(BrowseContext browseContext) {
        if (log.isDebugEnabled()) {
            log.debug("Rendering commits for " + browseContext.getProject().getKey());
        }
        HashMap<String, Object> startingParams = new HashMap<String, Object>();
        Project project = browseContext.getProject();
        String key = project.getKey();
        ApplicationUser user = browseContext.getUser();
        startingParams.put("action", this.getI18nBean(user));
        startingParams.put("project", project);
        startingParams.put("projectKey", key);
        startingParams.put("urlPrefix", this.getUrlPrefix());
        startingParams.put("versionManager", this.versionManager);
        long versionNumber = this.getVersionRequestParameter();
        Version version = null;
        if (versionNumber != -1L) {
            startingParams.put("versionNumber", (int)versionNumber);
            version = this.versionManager.getVersion(Long.valueOf(versionNumber));
            startingParams.put("selectedVersion", version);
        }
        int pageSize = this.getPageSizeRequestParameter();
        List<SubversionProjectRevisionAction> recentCommits = this.getRecentCommits(key, version, user, this.getPageRequestParameter() * pageSize, pageSize + 1);
        if (recentCommits.size() > pageSize) {
            startingParams.put("moreAvailable", true);
            recentCommits = recentCommits.subList(0, pageSize);
        }
        startingParams.put("commits", recentCommits);
        startingParams.put("releasedVersions", this.versionManager.getVersionsReleased(project.getId(), false));
        startingParams.put("unreleasedVersions", this.versionManager.getVersionsUnreleased(project.getId(), false));
        startingParams.put("stringUtils", new StringUtils());
        return this.descriptor.getHtml("view", startingParams);
    }

    I18nBean getI18nBean(ApplicationUser user) {
        return new I18nBean(user);
    }

    private List<SubversionProjectRevisionAction> getRecentCommits(String key, Version version, ApplicationUser user, int startIndex, int pageSize) {
        if (log.isDebugEnabled()) {
            log.debug("Getting recent commits for project " + key + " and version " + version);
        }
        ArrayList<SubversionProjectRevisionAction> actions = new ArrayList<SubversionProjectRevisionAction>();
        try {
            RevisionIndexer indexer = this.multipleSubversionRepositoryManager.getRevisionIndexer();
            Map<Long, List<SVNLogEntry>> logEntries = version == null ? indexer.getLogEntriesByProject(key, user, startIndex, pageSize) : indexer.getLogEntriesByVersion(version, user, startIndex, pageSize);
            if (logEntries != null && logEntries.size() > 0) {
                for (Map.Entry<Long, List<SVNLogEntry>> entry : logEntries.entrySet()) {
                    long repoId = entry.getKey();
                    for (SVNLogEntry logEntry : entry.getValue()) {
                        actions.add(this.createProjectRevisionAction(repoId, logEntry));
                    }
                }
            }
        }
        catch (IndexException ie) {
            log.error("There' a problem with the index.", (Throwable)ie);
        }
        catch (IOException ioe) {
            log.error("Error reading the index.", (Throwable)ioe);
        }
        return actions;
    }

    SubversionProjectRevisionAction createProjectRevisionAction(long repoId, SVNLogEntry logEntry) {
        return new SubversionProjectRevisionAction(logEntry, this.multipleSubversionRepositoryManager, this.descriptor, repoId);
    }

    private long getVersionRequestParameter() {
        String selectedVersion;
        long versionNumber = 0L;
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null && StringUtils.isNotBlank((String)(selectedVersion = request.getParameter("selectedVersion")))) {
            try {
                versionNumber = Long.parseLong(selectedVersion);
            }
            catch (NumberFormatException e) {
                log.error("Unknown version string: " + selectedVersion, (Throwable)e);
            }
        }
        return versionNumber;
    }

    private int getPageRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageIndex");
            return StringUtils.isBlank((String)pageIndexString) ? 0 : Integer.parseInt(pageIndexString);
        }
        return 0;
    }

    private int getPageSizeRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageSize");
            return StringUtils.isBlank((String)pageIndexString) ? 100 : Integer.parseInt(pageIndexString);
        }
        return 100;
    }

    public boolean showPanel(BrowseContext browseContext) {
        return this.multipleSubversionRepositoryManager.isIndexingRevisions() && this.permissionManager.hasPermission(29, browseContext.getProject(), browseContext.getUser());
    }

    private String getUrlPrefix() {
        if (this.buildUtilsInfo.getVersion().startsWith("6.3")) {
            return "browse";
        }
        return "projects";
    }
}

