/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.messages;

import com.atlassian.cache.CachedReference;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.messages.IndexMessageService;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

public class DefaultIndexMessageService
implements IndexMessageService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIndexMessageService.class);
    private static final String INDEX_MESSAGE_CHANNEL = "INDEX_CHANNEL";
    private final ClusterMessagingService clusterMessagingService;
    private final IndexMessageConsumer messageConsumer;
    private final RevisionIndexer revisionIndexer;
    private final CachedReference<Map<Long, SubversionManager>> cachedSvnManagers;

    public DefaultIndexMessageService(ClusterMessagingService clusterMessagingService, RevisionIndexer revisionIndexer, CachedReference<Map<Long, SubversionManager>> cachedSvnManagers) {
        this.clusterMessagingService = clusterMessagingService;
        this.revisionIndexer = revisionIndexer;
        this.messageConsumer = new IndexMessageConsumer();
        this.cachedSvnManagers = cachedSvnManagers;
    }

    @Override
    public void removeIndexForRepository(long repositoryId) {
        this.clusterMessagingService.sendRemote(INDEX_MESSAGE_CHANNEL, this.createMessage(IndexMessageType.REMOVE_INDEX, repositoryId));
    }

    @Override
    public void addIndexForRepository(long repositoryId) {
        this.clusterMessagingService.sendRemote(INDEX_MESSAGE_CHANNEL, this.createMessage(IndexMessageType.ADD_INDEX, repositoryId));
    }

    @Override
    public void registerListeners() {
        if (logger.isInfoEnabled()) {
            logger.info("Registered IndexMessageConsumer: " + this.messageConsumer);
        }
        this.clusterMessagingService.registerListener(INDEX_MESSAGE_CHANNEL, (ClusterMessageConsumer)this.messageConsumer);
    }

    @Override
    public void unregisterListeners() {
        if (logger.isInfoEnabled()) {
            logger.info("Unregistered IndexMessageConsumer: " + this.messageConsumer);
        }
        this.clusterMessagingService.unregisterListener(INDEX_MESSAGE_CHANNEL, (ClusterMessageConsumer)this.messageConsumer);
    }

    private String createMessage(IndexMessageType messagesType, long repositoryId) {
        return messagesType.name() + "|" + repositoryId;
    }

    private ParsedIndexMessage parseClusterMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Indexing message can't be blank: '" + message + "'");
        }
        String[] tokens = message.split("\\|");
        if (tokens.length < 2 || StringUtils.isBlank((CharSequence)tokens[0]) || StringUtils.isBlank((CharSequence)tokens[1])) {
            throw new IllegalArgumentException("Invalid indexing message: '" + message + "'");
        }
        return new ParsedIndexMessage(tokens[0], tokens[1]);
    }

    private void invalidateCacheWhenRepositoryNotFound(long repositoryId) {
        if (this.cachedSvnManagers.get() != null && ((Map)this.cachedSvnManagers.get()).get(repositoryId) == null) {
            this.cachedSvnManagers.reset();
        }
    }

    private class ParsedIndexMessage {
        private IndexMessageType indexMessageType;
        private String messageParam;

        private ParsedIndexMessage(String messageType, String messageParam) {
            this.indexMessageType = IndexMessageType.valueOf(messageType);
            this.messageParam = messageParam;
        }

        private IndexMessageType getIndexMessageType() {
            return this.indexMessageType;
        }

        private String getMessageParam() {
            return this.messageParam;
        }
    }

    private class IndexMessageConsumer
    implements ClusterMessageConsumer {
        private IndexMessageConsumer() {
        }

        public void receive(String channel, String message, String sender) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received message: " + message + " in channel: " + channel + " from sender: " + sender);
            }
            if (DefaultIndexMessageService.INDEX_MESSAGE_CHANNEL.equals(channel)) {
                ParsedIndexMessage parsedIndexMessage = DefaultIndexMessageService.this.parseClusterMessage(message);
                try {
                    parsedIndexMessage.getIndexMessageType().callIndexAction(DefaultIndexMessageService.this, parsedIndexMessage);
                }
                catch (Exception e) {
                    throw new InfrastructureException("Could not update repository index", (Throwable)e);
                }
            }
        }
    }

    private static enum IndexMessageType {
        ADD_INDEX,
        REMOVE_INDEX;


        public void callIndexAction(DefaultIndexMessageService indexService, ParsedIndexMessage parsedIndexMessage) throws SVNException, IndexException, IOException {
            Long repositoryId = Long.valueOf(parsedIndexMessage.getMessageParam());
            switch (this) {
                case ADD_INDEX: {
                    indexService.invalidateCacheWhenRepositoryNotFound(repositoryId);
                    indexService.revisionIndexer.addRepository(repositoryId);
                    break;
                }
                case REMOVE_INDEX: {
                    indexService.invalidateCacheWhenRepositoryNotFound(repositoryId);
                    indexService.revisionIndexer.removeEntries(Long.valueOf(parsedIndexMessage.getMessageParam()));
                }
            }
        }
    }
}

