/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.issuetabpanels.changes;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.issuetabpanels.changes.SubversionRevisionAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNLogEntry;
import webwork.action.ActionContext;

public class SubversionRevisionsTabPanel
extends AbstractIssueTabPanel {
    private static final Logger log = LoggerFactory.getLogger(SubversionRevisionsTabPanel.class);
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final VelocityRequestContextFactory requestContextFactory;
    public static final int NUMBER_OF_REVISIONS = 100;

    public SubversionRevisionsTabPanel(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, PermissionManager permissionManager, WebResourceManager webResourceManager, VelocityRequestContextFactory requestContextFactory) {
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
        this.requestContextFactory = requestContextFactory;
    }

    public List getActions(Issue issue, ApplicationUser remoteUser) {
        this.webResourceManager.requireResource("com.atlassian.jira.plugin.ext.subversion:subversion-resource-js");
        try {
            boolean sortAscending = false;
            int pageSize = this.getPageSizeRequestParameter();
            Map<Long, List<SVNLogEntry>> logEntries = this.multipleSubversionRepositoryManager.getRevisionIndexer().getLogEntriesByRepository(issue, this.getPageRequestParameter() * pageSize, pageSize + 1, false);
            if (logEntries == null) {
                GenericMessageAction action = new GenericMessageAction(this.getText("no.index.error.message"));
                return EasyList.build((Object)action);
            }
            if (logEntries.isEmpty()) {
                GenericMessageAction action = new GenericMessageAction(this.getText("no.log.entries.message"));
                return EasyList.build((Object)action);
            }
            List<SubversionRevisionAction> actions = new ArrayList();
            for (Map.Entry<Long, List<SVNLogEntry>> entry : logEntries.entrySet()) {
                for (SVNLogEntry logEntry : entry.getValue()) {
                    actions.add(this.createSubversionRevisionAction(entry.getKey(), logEntry));
                }
            }
            Collections.reverse(actions);
            if (!actions.isEmpty() && actions.size() > pageSize) {
                actions = actions.subList(1, actions.size());
                int lastActionIndex = 0;
                SubversionRevisionAction lastAction = (SubversionRevisionAction)((Object)actions.get(lastActionIndex));
                actions.set(lastActionIndex, this.createLastSubversionRevisionActionInPage(lastAction.getRepoId(), lastAction.getRevision()));
            }
            return actions;
        }
        catch (IndexException ie) {
            log.error("There's a problem with the Subversion index.", (Throwable)ie);
        }
        catch (IOException ioe) {
            log.error("Unable to read Subversion index.", (Throwable)ioe);
        }
        return Collections.emptyList();
    }

    private int getPageRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageIndex");
            return StringUtils.isBlank((String)pageIndexString) ? 0 : Integer.parseInt(pageIndexString);
        }
        return 0;
    }

    private int getPageSizeRequestParameter() {
        HttpServletRequest req = ActionContext.getRequest();
        if (null != req) {
            String pageIndexString = req.getParameter("pageSize");
            return StringUtils.isBlank((String)pageIndexString) ? 100 : Integer.parseInt(pageIndexString);
        }
        return 100;
    }

    SubversionRevisionAction createSubversionRevisionAction(long repoId, SVNLogEntry logEntry) {
        return new SubversionRevisionAction(logEntry, this.multipleSubversionRepositoryManager, this.descriptor, repoId);
    }

    SubversionRevisionAction createLastSubversionRevisionActionInPage(long repoId, SVNLogEntry logEntry) {
        return new LastSubversionRevisionActionInPage(logEntry, this.multipleSubversionRepositoryManager, this.descriptor, repoId);
    }

    String getText(String key) {
        return this.descriptor.getI18nBean().getText(key);
    }

    public boolean showPanel(Issue issue, ApplicationUser remoteUser) {
        return this.multipleSubversionRepositoryManager.isIndexingRevisions() && this.permissionManager.hasPermission(29, issue, remoteUser);
    }

    private class LastSubversionRevisionActionInPage
    extends SubversionRevisionAction {
        public LastSubversionRevisionActionInPage(SVNLogEntry logEntry, MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, IssueTabPanelModuleDescriptor descriptor, long repoId) {
            super(logEntry, multipleSubversionRepositoryManager, descriptor, repoId);
        }
    }
}

