/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffWindow {
    public static final byte[] SVN_HEADER = new byte[]{83, 86, 78, 0};
    public static final byte[] SVN1_HEADER = new byte[]{83, 86, 78, 1};
    public static final SVNDiffWindow EMPTY = new SVNDiffWindow(0L, 0, 0, 0, 0);
    private final long mySourceViewOffset;
    private final int mySourceViewLength;
    private final int myTargetViewLength;
    private final int myNewDataLength;
    private int myInstructionsLength;
    private SVNDiffInstruction myTemplateInstruction = new SVNDiffInstruction(0, 0, 0);
    private SVNDiffInstruction myTemplateNextInstruction = new SVNDiffInstruction(0, 0, 0);
    private byte[] myData;
    private int myDataOffset;
    private int myInstructionsCount;

    public SVNDiffWindow(long sourceViewOffset, int sourceViewLength, int targetViewLength, int instructionsLength, int newDataLength) {
        this.mySourceViewOffset = sourceViewOffset;
        this.mySourceViewLength = sourceViewLength;
        this.myTargetViewLength = targetViewLength;
        this.myInstructionsLength = instructionsLength;
        this.myNewDataLength = newDataLength;
    }

    public int getInstructionsLength() {
        return this.myInstructionsLength;
    }

    public long getSourceViewOffset() {
        return this.mySourceViewOffset;
    }

    public int getSourceViewLength() {
        return this.mySourceViewLength;
    }

    public int getTargetViewLength() {
        return this.myTargetViewLength;
    }

    public int getNewDataLength() {
        return this.myNewDataLength;
    }

    public Iterator instructions() {
        return this.instructions(false);
    }

    public Iterator instructions(boolean template) {
        return new InstructionsIterator(template);
    }

    public void apply(SVNDiffWindowApplyBaton applyBaton) throws SVNException {
        if (applyBaton.myTargetBuffer == null || applyBaton.myTargetViewSize < this.getTargetViewLength()) {
            applyBaton.myTargetBuffer = new byte[this.getTargetViewLength()];
        }
        applyBaton.myTargetViewSize = this.getTargetViewLength();
        int length = 0;
        if (this.getSourceViewOffset() != applyBaton.mySourceViewOffset || this.getSourceViewLength() > applyBaton.mySourceViewLength) {
            byte[] oldSourceBuffer = applyBaton.mySourceBuffer;
            applyBaton.mySourceBuffer = new byte[this.getSourceViewLength()];
            if (applyBaton.mySourceViewOffset + (long)applyBaton.mySourceViewLength > this.getSourceViewOffset()) {
                int start = (int)(this.getSourceViewOffset() - applyBaton.mySourceViewOffset);
                System.arraycopy(oldSourceBuffer, start, applyBaton.mySourceBuffer, 0, applyBaton.mySourceViewLength - start);
                length = applyBaton.mySourceViewLength - start;
            }
        }
        if (length < this.getSourceViewLength()) {
            try {
                int toSkip = (int)(this.getSourceViewOffset() - (applyBaton.mySourceViewOffset + (long)applyBaton.mySourceViewLength));
                if (toSkip > 0) {
                    applyBaton.mySourceStream.skip(toSkip);
                }
                SVNFileUtil.readIntoBuffer(applyBaton.mySourceStream, applyBaton.mySourceBuffer, length, applyBaton.mySourceBuffer.length - length);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
        }
        applyBaton.mySourceViewLength = this.getSourceViewLength();
        applyBaton.mySourceViewOffset = this.getSourceViewOffset();
        int tpos = 0;
        int npos = this.myInstructionsLength;
        try {
            Iterator instructions = this.instructions(true);
            while (instructions.hasNext()) {
                SVNDiffInstruction instruction = (SVNDiffInstruction)instructions.next();
                int iLength = instruction.length < this.getTargetViewLength() - tpos ? instruction.length : this.getTargetViewLength() - tpos;
                switch (instruction.type) {
                    case 2: {
                        System.arraycopy(this.myData, this.myDataOffset + npos, applyBaton.myTargetBuffer, tpos, iLength);
                        npos += iLength;
                        break;
                    }
                    case 1: {
                        int start = instruction.offset;
                        int end = instruction.offset + iLength;
                        int tIndex = tpos;
                        for (int j = start; j < end; ++j) {
                            applyBaton.myTargetBuffer[tIndex] = applyBaton.myTargetBuffer[j];
                            ++tIndex;
                        }
                        break;
                    }
                    case 0: {
                        System.arraycopy(applyBaton.mySourceBuffer, instruction.offset, applyBaton.myTargetBuffer, tpos, iLength);
                        break;
                    }
                }
                if ((tpos += instruction.length) < this.getTargetViewLength()) continue;
                break;
            }
            if (applyBaton.myDigest != null) {
                applyBaton.myDigest.update(applyBaton.myTargetBuffer, 0, this.getTargetViewLength());
            }
            applyBaton.myTargetStream.write(applyBaton.myTargetBuffer, 0, this.getTargetViewLength());
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
    }

    public int apply(byte[] sourceBuffer, byte[] targetBuffer) {
        int dataOffset = this.myInstructionsLength;
        int tpos = 0;
        Iterator instructions = this.instructions(true);
        while (instructions.hasNext()) {
            SVNDiffInstruction instruction = (SVNDiffInstruction)instructions.next();
            int iLength = instruction.length < this.getTargetViewLength() - tpos ? instruction.length : this.getTargetViewLength() - tpos;
            switch (instruction.type) {
                case 2: {
                    System.arraycopy(this.myData, this.myDataOffset + dataOffset, targetBuffer, tpos, iLength);
                    dataOffset += iLength;
                    break;
                }
                case 1: {
                    int start = instruction.offset;
                    int end = instruction.offset + iLength;
                    int tIndex = tpos;
                    for (int j = start; j < end; ++j) {
                        targetBuffer[tIndex] = targetBuffer[j];
                        ++tIndex;
                    }
                    break;
                }
                case 0: {
                    System.arraycopy(sourceBuffer, instruction.offset, targetBuffer, tpos, iLength);
                    break;
                }
            }
            if ((tpos += instruction.length) < this.getTargetViewLength()) continue;
            break;
        }
        return this.getTargetViewLength();
    }

    public void setData(ByteBuffer buffer) {
        this.myData = buffer.array();
        this.myDataOffset = buffer.position() + buffer.arrayOffset();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSourceViewOffset());
        sb.append(":");
        sb.append(this.getSourceViewLength());
        sb.append(":");
        sb.append(this.getTargetViewLength());
        sb.append(":");
        sb.append(this.getInstructionsLength());
        sb.append(":");
        sb.append(this.getNewDataLength());
        sb.append(":");
        sb.append(this.getDataLength());
        sb.append(":");
        sb.append(this.myDataOffset);
        return sb.toString();
    }

    public boolean hasInstructions() {
        return this.myInstructionsLength > 0;
    }

    public void writeTo(OutputStream os, boolean writeHeader) throws IOException {
        this.writeTo(os, writeHeader, false);
    }

    public void writeTo(OutputStream os, boolean writeHeader, boolean compress) throws IOException {
        if (writeHeader) {
            os.write(compress ? SVN1_HEADER : SVN_HEADER);
        }
        if (!this.hasInstructions()) {
            return;
        }
        ByteBuffer offsets = ByteBuffer.allocate(100);
        SVNDiffInstruction.writeLong(offsets, this.mySourceViewOffset);
        SVNDiffInstruction.writeInt(offsets, this.mySourceViewLength);
        SVNDiffInstruction.writeInt(offsets, this.myTargetViewLength);
        ByteBuffer instructions = null;
        ByteBuffer newData = null;
        int instLength = 0;
        int dataLength = 0;
        if (compress) {
            instructions = SVNDiffWindow.inflate(this.myData, this.myDataOffset, this.myInstructionsLength);
            instLength = instructions.remaining();
            newData = SVNDiffWindow.inflate(this.myData, this.myDataOffset + this.myInstructionsLength, this.myNewDataLength);
            dataLength = newData.remaining();
            SVNDiffInstruction.writeInt(offsets, instLength);
            SVNDiffInstruction.writeInt(offsets, dataLength);
        } else {
            SVNDiffInstruction.writeInt(offsets, this.myInstructionsLength);
            SVNDiffInstruction.writeInt(offsets, this.myNewDataLength);
        }
        os.write(offsets.array(), offsets.arrayOffset(), offsets.position());
        if (compress) {
            os.write(instructions.array(), instructions.arrayOffset(), instructions.remaining());
            os.write(newData.array(), newData.arrayOffset(), newData.remaining());
        } else {
            os.write(this.myData, this.myDataOffset, this.myInstructionsLength);
            if (this.myNewDataLength > 0) {
                os.write(this.myData, this.myDataOffset + this.myInstructionsLength, this.myNewDataLength);
            }
        }
    }

    public int getDataLength() {
        return this.myNewDataLength + this.myInstructionsLength;
    }

    public boolean hasCopyFromSourceInstructions() {
        Iterator instrs = this.instructions(true);
        while (instrs.hasNext()) {
            SVNDiffInstruction instruction = (SVNDiffInstruction)instrs.next();
            if (instruction.type != 0) continue;
            return true;
        }
        return false;
    }

    public SVNDiffWindow clone(ByteBuffer targetData) {
        int targetOffset = targetData.position() + targetData.arrayOffset();
        int position = targetData.position();
        targetData.put(this.myData, this.myDataOffset, this.myInstructionsLength + this.myNewDataLength);
        targetData.position(position);
        SVNDiffWindow clone = new SVNDiffWindow(this.getSourceViewOffset(), this.getSourceViewLength(), this.getTargetViewLength(), this.getInstructionsLength(), this.getNewDataLength());
        clone.setData(targetData);
        clone.myDataOffset = targetOffset;
        return clone;
    }

    private static ByteBuffer inflate(byte[] src, int offset, int length) throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocate(length * 2 + 2);
        SVNDiffInstruction.writeInt(buffer, length);
        if (length < 512) {
            buffer.put(src, offset, length);
        } else {
            DeflaterOutputStream out = new DeflaterOutputStream(new OutputStream(){

                public void write(int b) throws IOException {
                    buffer.put((byte)(b & 0xFF));
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    buffer.put(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }
            });
            out.write(src, offset, length);
            out.finish();
            if (buffer.position() >= length) {
                buffer.clear();
                SVNDiffInstruction.writeInt(buffer, length);
                buffer.put(src, offset, length);
            }
        }
        buffer.flip();
        return buffer;
    }

    public SVNDiffInstruction[] loadDiffInstructions(SVNDiffInstruction[] target) {
        int index = 0;
        Iterator instructions = this.instructions();
        while (instructions.hasNext()) {
            if (index >= target.length) {
                SVNDiffInstruction[] newTarget = new SVNDiffInstruction[index * 3 / 2];
                System.arraycopy(target, 0, newTarget, 0, index);
                target = newTarget;
            }
            target[index] = (SVNDiffInstruction)instructions.next();
            ++index;
        }
        this.myInstructionsCount = index;
        return target;
    }

    public int getInstructionsCount() {
        return this.myInstructionsCount;
    }

    public void writeNewData(ByteBuffer target, int offset, int length) {
        target.put(this.myData, offset += this.myDataOffset + this.myInstructionsLength, length);
    }

    private class InstructionsIterator
    implements Iterator {
        private SVNDiffInstruction myNextInsruction;
        private int myOffset;
        private int myNewDataOffset;
        private boolean myIsTemplate;

        public InstructionsIterator(boolean useTemplate) {
            this.myIsTemplate = useTemplate;
            this.myNextInsruction = this.readNextInstruction();
        }

        public boolean hasNext() {
            return this.myNextInsruction != null;
        }

        public Object next() {
            if (this.myNextInsruction == null) {
                return null;
            }
            if (this.myIsTemplate) {
                ((SVNDiffWindow)SVNDiffWindow.this).myTemplateNextInstruction.type = this.myNextInsruction.type;
                ((SVNDiffWindow)SVNDiffWindow.this).myTemplateNextInstruction.length = this.myNextInsruction.length;
                ((SVNDiffWindow)SVNDiffWindow.this).myTemplateNextInstruction.offset = this.myNextInsruction.offset;
                this.myNextInsruction = this.readNextInstruction();
                return SVNDiffWindow.this.myTemplateNextInstruction;
            }
            SVNDiffInstruction next = this.myNextInsruction;
            this.myNextInsruction = this.readNextInstruction();
            return next;
        }

        public void remove() {
        }

        private SVNDiffInstruction readNextInstruction() {
            if (SVNDiffWindow.this.myData == null || this.myOffset >= SVNDiffWindow.this.myInstructionsLength) {
                return null;
            }
            SVNDiffInstruction instruction = this.myIsTemplate ? SVNDiffWindow.this.myTemplateInstruction : new SVNDiffInstruction();
            instruction.type = (SVNDiffWindow.this.myData[SVNDiffWindow.this.myDataOffset + this.myOffset] & 0xC0) >> 6;
            instruction.length = SVNDiffWindow.this.myData[SVNDiffWindow.this.myDataOffset + this.myOffset] & 0x3F;
            ++this.myOffset;
            if (instruction.length == 0) {
                instruction.length = this.readInt();
            }
            if (instruction.type == 0 || instruction.type == 1) {
                instruction.offset = this.readInt();
            } else {
                instruction.offset = this.myNewDataOffset;
                this.myNewDataOffset += instruction.length;
            }
            return instruction;
        }

        private int readInt() {
            int result;
            block1: {
                result = 0;
                do {
                    byte b = SVNDiffWindow.this.myData[SVNDiffWindow.this.myDataOffset + this.myOffset];
                    result <<= 7;
                    result |= b & 0x7F;
                    if ((b & 0x80) == 0) break block1;
                    ++this.myOffset;
                } while (this.myOffset < SVNDiffWindow.this.myInstructionsLength);
                return -1;
            }
            ++this.myOffset;
            return result;
        }
    }
}

