/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgWcToWcCopy
extends SvnNgOperationRunner<Void, SvnCopy> {
    @Override
    public boolean isApplicable(SvnCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        return this.areAllSourcesLocal(operation) && operation.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnCopy operation) {
        for (SvnCopySource source : operation.getSources()) {
            if (source.getSource().isFile() && (operation.isMove() || this.isLocalRevision(source.getRevision()) && this.isLocalRevision(source.getSource().getResolvedPegRevision()))) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalRevision(SVNRevision revision) {
        return revision == SVNRevision.WORKING || revision == SVNRevision.UNDEFINED;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        Collection<SvnCopySource> sources = ((SvnCopy)this.getOperation()).getSources();
        try {
            Void void_ = this.tryRun(context, sources, this.getFirstTarget());
            return void_;
        }
        catch (SVNException e) {
            SVNErrorCode code = e.getErrorMessage().getErrorCode();
            if (!(((SvnCopy)this.getOperation()).isFailWhenDstExists() || ((SvnCopy)this.getOperation()).getSources().size() != 1 || code != SVNErrorCode.ENTRY_EXISTS && code != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource source = sources.iterator().next();
                Void void_ = this.tryRun(context, sources, new File(this.getFirstTarget(), source.getSource().getFile().getName()));
                return void_;
            }
            throw e;
        }
        finally {
            this.sleepForTimestamp();
        }
    }

    protected Void tryRun(SVNWCContext context, Collection<SvnCopySource> sources, File target) throws SVNException {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy(context, target);
        }
        return this.copy(context, sources, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void disjointCopy(SVNWCContext context, File nestedWC) throws SVNException {
        nestedWC = new File(nestedWC.getAbsolutePath().replace(File.separatorChar, '/'));
        File nestedWCParent = nestedWC.getParentFile();
        this.checkForDisjointCopyPossibility(context, nestedWC, nestedWCParent);
        context.getDb().close();
        File wcRoot = context.getDb().getWCRoot(nestedWCParent);
        File tempDirectory = new File(this.getAdminDirectory(wcRoot), "tmp");
        SVNFileUtil.ensureDirectoryExists(tempDirectory);
        File fakeWorkingCopyDirectory = SVNFileUtil.createUniqueDir(tempDirectory, "disjoint-copy", "tmp", true);
        this.moveWcDb(nestedWC, fakeWorkingCopyDirectory);
        this.copyPristineFiles(nestedWC, wcRoot, true);
        SVNFileUtil.deleteAll(this.getAdminDirectory(nestedWC), true);
        context.getDb().forgetDirectoryTemp(nestedWC);
        File lockRoot = null;
        try {
            lockRoot = context.acquireWriteLock(wcRoot, true, true);
            this.copy(context, fakeWorkingCopyDirectory, nestedWC, true, ((SvnCopy)this.getOperation()).isVirtual());
        }
        finally {
            if (lockRoot != null) {
                context.releaseWriteLock(lockRoot);
            }
        }
        return null;
    }

    private void checkForDisjointCopyPossibility(SVNWCContext context, File nestedWC, File nestedWCParent) throws SVNException {
        SVNErrorMessage err;
        SVNWCDb wcdb;
        SVNErrorMessage err2;
        SVNFileType nestedWCType = SVNFileType.getType(nestedWC);
        if (nestedWCType != SVNFileType.DIRECTORY) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (nestedWCParent == null) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "{0} seems to be not a disjoint wc since it has no parent", (Object)nestedWC);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (!(context.getDb() instanceof SVNWCDb)) {
            err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported working copy format", (Object)nestedWC);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if (this.hasMetadataInParentWc(wcdb = (SVNWCDb)context.getDb(), nestedWC, nestedWCParent)) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Entry ''{0}'' already exists in parent directory", (Object)nestedWC.getName());
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(nestedWC, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        ISVNWCDb.WCDbBaseInfo parentBaseInfo = context.getDb().getBaseInfo(nestedWCParent, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
        if (baseInfo.reposRootUrl != null && parentBaseInfo.reposRootUrl != null && !baseInfo.reposRootUrl.equals(parentBaseInfo.reposRootUrl)) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", nestedWCParent, baseInfo.reposRootUrl, baseInfo.reposRootUrl);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        SVNWCContext.ScheduleInternalInfo parentSchedule = context.getNodeScheduleInternal(nestedWCParent, true, true);
        if (parentSchedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)nestedWCParent);
            SVNErrorManager.error(err5, SVNLogType.WC);
        }
        SVNWCContext.ScheduleInternalInfo schedule = context.getNodeScheduleInternal(nestedWC, true, true);
        if (schedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'', as it is scheduled for deletion", (Object)nestedWC);
            SVNErrorManager.error(err6, SVNLogType.WC);
        }
        File relativePath = baseInfo.reposRelPath;
        File parentRelativePath = parentBaseInfo.reposRelPath;
        if (relativePath == null || parentRelativePath == null) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'': cannot resolve its relative path, perhaps it is obstructed", (Object)nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNPathUtil.isAncestor(relativePath.getPath(), parentRelativePath.getPath())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", nestedWC, nestedWCParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (schedule.schedule == SVNWCContext.SVNWCSchedule.add && !schedule.copied || context.getNodeUrl(nestedWC) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void moveWcDb(File sourceWc, File targetWc) throws SVNException {
        File sourceWcDbFile = this.getWCDbFile(sourceWc);
        File targetWcDbFile = this.getWCDbFile(targetWc);
        SVNFileUtil.ensureDirectoryExists(targetWcDbFile.getParentFile());
        SVNFileUtil.rename(sourceWcDbFile, targetWcDbFile);
    }

    private void copyPristineFiles(File sourceWc, File targetWc, boolean move) throws SVNException {
        File sourcePristineDirectory = this.getPristineDirectory(sourceWc);
        File targetPristineDirectory = this.getPristineDirectory(targetWc);
        File[] sourceDirectories = SVNFileListUtil.listFiles(sourcePristineDirectory);
        if (sourceDirectories != null) {
            for (File sourceDirectory : sourceDirectories) {
                File targetDirectory = new File(targetPristineDirectory, sourceDirectory.getName());
                SVNFileUtil.ensureDirectoryExists(targetDirectory);
                File[] sourcePristineFiles = SVNFileListUtil.listFiles(sourceDirectory);
                if (sourcePristineFiles == null) continue;
                for (File sourcePristineFile : sourcePristineFiles) {
                    File targetPristineFile = new File(targetDirectory, sourcePristineFile.getName());
                    if (targetPristineFile.exists()) continue;
                    if (move) {
                        SVNFileUtil.rename(sourcePristineFile, targetPristineFile);
                        continue;
                    }
                    SVNFileUtil.copyFile(sourcePristineFile, targetPristineFile, false);
                }
            }
        }
        SVNFileUtil.deleteAll(sourcePristineDirectory, true);
    }

    private File getPristineDirectory(File workingCopyDirectory) {
        return new File(this.getAdminDirectory(workingCopyDirectory), "pristine");
    }

    private File getWCDbFile(File nestedWC) {
        return new File(this.getAdminDirectory(nestedWC), "wc.db");
    }

    private File getAdminDirectory(File parentWC) {
        String adminDirectoryName = SVNFileUtil.getAdminDirectoryName();
        return new File(parentWC, adminDirectoryName);
    }

    private boolean hasMetadataInParentWc(SVNWCDb wcdb, File nestedWC, File nestedWCParent) throws SVNException {
        SVNWCDbRoot wcdbRoot;
        SVNWCDb.DirParsedInfo parsedInfo = wcdb.obtainWcRoot(nestedWCParent);
        SVNWCDbDir wcDbDir = parsedInfo == null ? null : parsedInfo.wcDbDir;
        SVNWCDbRoot sVNWCDbRoot = wcdbRoot = wcDbDir == null ? null : wcDbDir.getWCRoot();
        if (wcdbRoot == null) {
            return false;
        }
        try {
            wcdb.readInfo(wcdbRoot, new File(SVNPathUtil.getRelativePath(nestedWCParent.getPath(), nestedWC.getPath())), new ISVNWCDb.WCDbInfo.InfoField[0]);
            return true;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void copy(SVNWCContext context, Collection<SvnCopySource> sources, File target) throws SVNException {
        SVNErrorMessage err;
        File src;
        ArrayList<SvnCopyPair> copyPairs = new ArrayList<SvnCopyPair>();
        if (sources.size() > 1) {
            if (((SvnCopy)this.getOperation()).isFailWhenDstExists()) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
                SVNErrorManager.error(err2, SVNLogType.DEFAULT);
            }
            for (SvnCopySource copySource : sources) {
                SvnCopyPair copyPair = new SvnCopyPair();
                copyPair.source = copySource.getSource().getFile();
                String baseName = copyPair.source.getName();
                copyPair.dst = new File(target, baseName);
                copyPairs.add(copyPair);
            }
        } else if (sources.size() == 1) {
            SvnCopyPair copyPair = new SvnCopyPair();
            SvnCopySource source = sources.iterator().next();
            copyPair.source = new File(SVNPathUtil.validateFilePath(source.getSource().getFile().getAbsolutePath()));
            copyPair.dst = target;
            copyPairs.add(copyPair);
        }
        for (SvnCopyPair pair : copyPairs) {
            src = pair.source;
            File dst = pair.dst;
            if (((SvnCopy)this.getOperation()).isMove() && src.getAbsolutePath().equals(dst.getAbsolutePath())) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move path ''{0}'' into itself", (Object)src);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!SVNWCUtils.isChild(src, dst)) continue;
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}''", src, dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (((SvnCopy)this.getOperation()).isMove()) {
            for (SvnCopyPair pair : copyPairs) {
                src = pair.source;
                try {
                    Structure<StructureFields.ExternalNodeInfo> externalInfo = SvnWcDbExternals.readExternal(context, src, src, StructureFields.ExternalNodeInfo.kind);
                    if (!externalInfo.hasValue(StructureFields.ExternalNodeInfo.kind) || externalInfo.get(StructureFields.ExternalNodeInfo.kind) == SVNNodeKind.NONE) continue;
                    err = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_MOVE_FILE_EXTERNAL, "Cannot move the external at ''{0}''; please edit the svn:externals property on ''{1}''.", (Object)src);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                    throw e;
                }
            }
        }
        this.verifyPaths(copyPairs, ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isMove());
        if (((SvnCopy)this.getOperation()).isMove()) {
            this.move(copyPairs);
        } else {
            File dstAncestor = null;
            if (copyPairs.size() >= 1) {
                dstAncestor = ((SvnCopyPair)copyPairs.iterator().next()).dst;
            }
            if (copyPairs.size() > 1 && dstAncestor != null) {
                dstAncestor = SVNFileUtil.getParentFile(dstAncestor);
            }
            dstAncestor = dstAncestor.getAbsoluteFile();
            dstAncestor = context.acquireWriteLock(dstAncestor, false, true);
            try {
                for (SvnCopyPair copyPair : copyPairs) {
                    this.checkCancelled();
                    File dstPath = SVNFileUtil.createFilePath(copyPair.dstParent, copyPair.baseName);
                    this.copy(context, copyPair.source, dstPath, ((SvnCopy)this.getOperation()).isVirtual(), ((SvnCopy)this.getOperation()).isVirtual());
                }
            }
            finally {
                context.releaseWriteLock(dstAncestor);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Collection<SvnCopyPair> pairs) throws SVNException {
        for (SvnCopyPair copyPair : pairs) {
            HashSet<File> lockPaths = new HashSet<File>();
            HashSet<File> lockedPaths = new HashSet<File>();
            this.checkCancelled();
            File sourceParent = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(copyPair.source).getAbsolutePath()));
            if (sourceParent.equals(copyPair.dstParent) || SVNWCUtils.isChild(sourceParent, copyPair.dstParent)) {
                lockPaths.add(sourceParent);
            } else if (SVNWCUtils.isChild(copyPair.dstParent, sourceParent)) {
                lockPaths.add(copyPair.dstParent);
            } else {
                lockPaths.add(sourceParent);
                lockPaths.add(copyPair.dstParent);
            }
            try {
                for (File file : lockPaths) {
                    lockedPaths.add(this.getWcContext().acquireWriteLock(file, false, true));
                }
                this.move(this.getWcContext(), copyPair.source, SVNFileUtil.createFilePath(copyPair.dstParent, copyPair.baseName), ((SvnCopy)this.getOperation()).isVirtual());
            }
            finally {
                for (File file : lockedPaths) {
                    this.getWcContext().releaseWriteLock(file);
                }
            }
        }
    }

    private void verifyPaths(Collection<SvnCopyPair> copyPairs, boolean makeParents, boolean move) throws SVNException {
        for (SvnCopyPair copyPair : copyPairs) {
            SVNFileType srcType = SVNFileType.getType(copyPair.source);
            SVNFileType dstType = SVNFileType.getType(copyPair.dst);
            if (((SvnCopy)this.getOperation()).isVirtual()) {
                this.verifyPathsExistenceForVirtualCopy(copyPair.source, copyPair.dst, srcType, dstType, copyPair, move);
            } else {
                boolean caseOnlyRename = this.verifyPaths(srcType, dstType, copyPair, copyPairs.size(), move);
                if (caseOnlyRename) {
                    return;
                }
            }
            copyPair.dstParent = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(copyPair.dst).getAbsolutePath()));
            copyPair.baseName = SVNFileUtil.getFileName(copyPair.dst);
            SVNFileType dstParentType = SVNFileType.getType(copyPair.dstParent);
            if (makeParents && (dstParentType == SVNFileType.NONE || ((SvnCopy)this.getOperation()).isVirtual())) {
                SVNFileUtil.ensureDirectoryExists(copyPair.dstParent);
                SvnScheduleForAddition add = ((SvnCopy)this.getOperation()).getOperationFactory().createScheduleForAddition();
                add.setSingleTarget(SvnTarget.fromFile(copyPair.dstParent));
                add.setDepth(((SvnCopy)this.getOperation()).isVirtual() ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                add.setIncludeIgnored(true);
                add.setForce(false);
                add.setAddParents(true);
                add.setSleepForTimestamp(false);
                try {
                    add.run();
                    continue;
                }
                catch (SVNException e) {
                    if (dstParentType == SVNFileType.NONE) {
                        SVNFileUtil.deleteAll(copyPair.dstParent, true);
                    }
                    throw e;
                }
            }
            if (dstParentType == SVNFileType.DIRECTORY) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "Path ''{0}'' is not a directory", (Object)copyPair.dstParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private boolean verifyPaths(SVNFileType srcType, SVNFileType dstType, SvnCopyPair copyPair, int copyPairsCount, boolean move) throws SVNException {
        SVNErrorMessage err;
        if (srcType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType != SVNFileType.NONE) {
            File dstDir;
            File srcDir;
            if (move && copyPairsCount == 1 && (srcDir = SVNFileUtil.getFileDir(copyPair.source)).equals(dstDir = SVNFileUtil.getFileDir(copyPair.dst)) && copyPair.source.getName().equalsIgnoreCase(copyPair.dst.getName())) {
                copyPair.dstParent = new File(SVNPathUtil.validateFilePath(dstDir.getAbsolutePath()));
                copyPair.baseName = SVNFileUtil.getFileName(copyPair.dst);
                return true;
            }
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return false;
    }

    private void verifyPathsExistenceForVirtualCopy(File source, File dst, SVNFileType srcType, SVNFileType dstType, SvnCopyPair copyPair, boolean move) throws SVNException {
        SvnStatus sourceStatus;
        SvnStatus dstStatus;
        SVNErrorMessage err;
        String opName;
        String string = opName = move ? "move" : "copy";
        if (move && srcType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", opName, copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", opName, copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, copyPair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!move && srcType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, copyPair.source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((dstStatus = this.getStatus(dst)) != null && dstStatus.getNodeStatus() != SVNStatusType.STATUS_UNVERSIONED && dstStatus.getNodeStatus() != SVNStatusType.STATUS_ADDED && dstStatus.getNodeStatus() != SVNStatusType.STATUS_REPLACED) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", opName, dst);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        if ((sourceStatus = this.getStatus(source)) == null || sourceStatus.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)source);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
    }

    private SvnStatus getStatus(File interestingFile) throws SVNException {
        final String interestingPath = SVNFileUtil.getFilePath(interestingFile);
        final SvnStatus[] status2 = new SvnStatus[1];
        SvnOperationFactory operationFactory = ((SvnCopy)this.getOperation()).getOperationFactory();
        SvnGetStatus status = operationFactory.createGetStatus();
        status.setDepth(SVNDepth.INFINITY);
        status.setRemote(false);
        status.setReportAll(true);
        status.setReportIgnored(true);
        status.setReportExternals(false);
        status.setApplicalbeChangelists(null);
        status.addTarget(SvnTarget.fromFile(interestingFile.getParentFile()));
        status.setReceiver(new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus svnStatus) throws SVNException {
                if (svnStatus == null) {
                    return;
                }
                File path = svnStatus.getPath();
                if (path == null) {
                    return;
                }
                String statusPath = SVNFileUtil.getFilePath(path);
                if (statusPath.equals(interestingPath)) {
                    status2[0] = svnStatus;
                }
            }
        });
        status.run();
        return status2[0];
    }

    protected void move(SVNWCContext context, File source, File dst, boolean metadataOnly) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfo;
        this.copy(context, source, dst, true, ((SvnCopy)this.getOperation()).isVirtual());
        if (!metadataOnly) {
            SVNFileUtil.rename(source, dst);
        }
        if ((nodeInfo = context.getDb().readInfo(source, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted)).get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir) {
            // empty if block
        }
        if (nodeInfo.is(StructureFields.NodeInfo.conflicted)) {
            // empty if block
        }
        SvnNgRemove.delete(this.getWcContext(), source, true, false, this);
    }

    protected void copy(SVNWCContext context, File source, File dst, boolean metadataOnly, boolean virtualCopy) throws SVNException {
        SVNFileType dstType;
        boolean srcConflicted;
        SvnChecksum srcChecksum;
        ISVNWCDb.SVNWCDbKind srcKind;
        ISVNWCDb.SVNWCDbStatus srcStatus;
        block29: {
            SVNErrorMessage err;
            ISVNWCDb.WCDbRepositoryInfo reposInfo;
            Structure<StructureFields.AdditionInfo> additionInfo;
            File dstDirectory = SVNFileUtil.getParentFile(dst);
            Structure<StructureFields.NodeInfo> srcInfo = null;
            try {
                srcInfo = context.getDb().readInfo(source, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.conflicted);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)source);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                throw e;
            }
            srcStatus = (ISVNWCDb.SVNWCDbStatus)((Object)srcInfo.get(StructureFields.NodeInfo.status));
            switch (srcStatus) {
                case Deleted: {
                    if (metadataOnly) break;
                    SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Deleted node ''{0}'' can''t be copied.", (Object)source);
                    SVNErrorManager.error(err1, SVNLogType.WC);
                    break;
                }
                case Excluded: 
                case ServerExcluded: 
                case NotPresent: {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)source);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            }
            Structure<StructureFields.NodeInfo> dstDirInfo = context.getDb().readInfo(dstDirectory, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid);
            SVNURL dstReposRootUrl = (SVNURL)dstDirInfo.get(StructureFields.NodeInfo.reposRootUrl);
            String dstReposUuid = (String)dstDirInfo.get(StructureFields.NodeInfo.reposUuid);
            ISVNWCDb.SVNWCDbStatus dstDirStatus = (ISVNWCDb.SVNWCDbStatus)((Object)dstDirInfo.get(StructureFields.NodeInfo.status));
            dstDirInfo.release();
            SVNURL srcReposRootUrl = (SVNURL)srcInfo.get(StructureFields.NodeInfo.reposRootUrl);
            String srcReposUuid = (String)srcInfo.get(StructureFields.NodeInfo.reposUuid);
            srcKind = (ISVNWCDb.SVNWCDbKind)((Object)srcInfo.get(StructureFields.NodeInfo.kind));
            srcChecksum = (SvnChecksum)srcInfo.get(StructureFields.NodeInfo.checksum);
            srcConflicted = srcInfo.is(StructureFields.NodeInfo.conflicted);
            if (srcReposRootUrl == null) {
                if (srcStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                    additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)context.getDb(), source);
                    srcReposRootUrl = (SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl);
                    srcReposUuid = (String)additionInfo.get(StructureFields.AdditionInfo.reposUuid);
                    additionInfo.release();
                } else {
                    reposInfo = context.getDb().scanBaseRepository(source, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    srcReposRootUrl = reposInfo.rootUrl;
                    srcReposUuid = reposInfo.uuid;
                }
            }
            if (dstReposRootUrl == null) {
                if (dstDirStatus == ISVNWCDb.SVNWCDbStatus.Added) {
                    additionInfo = SvnWcDbShared.scanAddition((SVNWCDb)context.getDb(), dstDirectory);
                    dstReposRootUrl = (SVNURL)additionInfo.get(StructureFields.AdditionInfo.reposRootUrl);
                    dstReposUuid = (String)additionInfo.get(StructureFields.AdditionInfo.reposUuid);
                    additionInfo.release();
                } else {
                    reposInfo = context.getDb().scanBaseRepository(dstDirectory, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid);
                    dstReposRootUrl = reposInfo.rootUrl;
                    dstReposUuid = reposInfo.uuid;
                }
            }
            if (srcReposRootUrl != null && dstReposRootUrl != null && !srcReposRootUrl.equals(dstReposRootUrl) || srcReposUuid != null && dstReposUuid != null && !srcReposUuid.equals(dstReposUuid)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", dst, srcReposRootUrl, dstReposRootUrl);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dstDirStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)dst);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            try {
                Structure<StructureFields.NodeInfo> dstInfo = context.getDb().readInfo(dst, StructureFields.NodeInfo.status);
                ISVNWCDb.SVNWCDbStatus dstStatus = (ISVNWCDb.SVNWCDbStatus)((Object)dstInfo.get(StructureFields.NodeInfo.status));
                switch (dstStatus) {
                    case Excluded: {
                        SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control but is excluded.", (Object)dst);
                        SVNErrorManager.error(err1, SVNLogType.WC);
                        break;
                    }
                    case ServerExcluded: {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)dst);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                        break;
                    }
                    case Deleted: 
                    case NotPresent: {
                        break;
                    }
                    default: {
                        if (virtualCopy) break;
                        SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)dst);
                        SVNErrorManager.error(err3, SVNLogType.WC);
                        break;
                    }
                }
                dstInfo.release();
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block29;
                throw e;
            }
        }
        if (!metadataOnly && (dstType = SVNFileType.getType(dst)) != SVNFileType.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", (Object)dst);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        File tmpDir = context.getDb().getWCRootTempDir(dst);
        if (srcKind == ISVNWCDb.SVNWCDbKind.File || srcKind == ISVNWCDb.SVNWCDbKind.Symlink) {
            boolean shouldCopyBaseData = this.shouldCopyBaseData(context, source, metadataOnly, srcStatus);
            if (shouldCopyBaseData) {
                this.copyBaseDataOfFile(context, source, dst);
            } else {
                this.copyVersionedFile(context, source, dst, dst, tmpDir, srcChecksum, metadataOnly, srcConflicted, true);
            }
        } else if (srcStatus == ISVNWCDb.SVNWCDbStatus.Deleted && metadataOnly) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", ((SvnCopy)this.getOperation()).isMove() ? "move" : "copy", source);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else {
            this.copyVersionedDirectory(context, source, dst, dst, tmpDir, metadataOnly, true);
        }
    }

    private boolean shouldCopyBaseData(SVNWCContext context, File source, boolean metadataOnly, ISVNWCDb.SVNWCDbStatus srcStatus) throws SVNException {
        if (!metadataOnly) {
            return false;
        }
        if (srcStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
            return true;
        }
        SvnStatus svnStatus = SVNStatusEditor17.internalStatus(context, source);
        return svnStatus != null && svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED;
    }

    private void copyBaseDataOfFile(SVNWCContext context, File source, File dst) throws SVNException {
        SVNProperties pristineProps = context.getPristineProps(source);
        ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(source, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid);
        String changedAuthor = baseInfo.changedAuthor;
        SVNDate changedDate = baseInfo.changedDate;
        long changedRev = baseInfo.changedRev;
        SvnChecksum checksum = baseInfo.checksum;
        long revision = baseInfo.revision;
        SVNURL reposRootUrl = baseInfo.reposRootUrl;
        String reposUuid = baseInfo.reposUuid;
        context.getDb().opCopyFile(dst, pristineProps, changedRev, changedDate, changedAuthor, context.getNodeReposRelPath(source.getAbsoluteFile()), reposRootUrl, reposUuid, revision, checksum, null, null);
        SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
        this.handleEvent(event);
    }

    private void copyVersionedDirectory(SVNWCContext wcContext, File source, File dst, File dstOpRoot, File tmpDir, boolean metadataOnly, boolean notify) throws SVNException {
        File childDstPath;
        File childSrcPath;
        SVNSkel workItems = null;
        SVNFileType srcType = null;
        if (!metadataOnly) {
            srcType = SVNFileType.getType(source);
            File tmpDst = this.copyToTmpDir(source, tmpDir, false);
            if (tmpDst != null) {
                SVNSkel workItem = wcContext.wqBuildFileMove(tmpDst, dst);
                workItems = wcContext.wqMerge(workItems, workItem);
            }
        }
        wcContext.getDb().opCopy(source, dst, workItems);
        wcContext.wqRun(SVNFileUtil.getParentFile(dst));
        if (notify) {
            SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.DIR, null, -1L, SVNEventAction.COPY, SVNEventAction.COPY, null, null, 1L, 1L);
            this.handleEvent(event);
        }
        HashSet<String> diskChildren = null;
        if (!metadataOnly && srcType == SVNFileType.DIRECTORY) {
            File[] children = SVNFileListUtil.listFiles(source);
            diskChildren = new HashSet<String>();
            for (int i = 0; children != null && i < children.length; ++i) {
                String name = SVNFileUtil.getFileName(children[i]);
                if (name.equals(SVNFileUtil.getAdminDirectoryName())) continue;
                diskChildren.add(name);
            }
        }
        Set<String> versionedChildren = wcContext.getDb().readChildren(source);
        for (String childName : versionedChildren) {
            this.checkCancelled();
            childSrcPath = SVNFileUtil.createFilePath(source, childName);
            childDstPath = SVNFileUtil.createFilePath(dst, childName);
            Structure<StructureFields.NodeInfo> childInfo = wcContext.getDb().readInfo(childSrcPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.conflicted, StructureFields.NodeInfo.opRoot);
            if (childInfo.is(StructureFields.NodeInfo.opRoot)) {
                wcContext.getDb().opCopyShadowedLayer(childSrcPath, childDstPath);
            }
            ISVNWCDb.SVNWCDbStatus childStatus = (ISVNWCDb.SVNWCDbStatus)((Object)childInfo.get(StructureFields.NodeInfo.status));
            ISVNWCDb.SVNWCDbKind childKind = (ISVNWCDb.SVNWCDbKind)((Object)childInfo.get(StructureFields.NodeInfo.kind));
            if (childStatus == ISVNWCDb.SVNWCDbStatus.Normal || childStatus == ISVNWCDb.SVNWCDbStatus.Added || childStatus == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                if (childKind == ISVNWCDb.SVNWCDbKind.File) {
                    boolean skip = false;
                    if (childStatus == ISVNWCDb.SVNWCDbStatus.Normal) {
                        Structure<StructureFields.NodeInfo> baseChildInfo = SvnWcDbReader.getBaseInfo((SVNWCDb)wcContext.getDb(), childSrcPath, StructureFields.NodeInfo.updateRoot);
                        skip = baseChildInfo.is(StructureFields.NodeInfo.updateRoot);
                        baseChildInfo.release();
                    }
                    if (!skip) {
                        SvnChecksum checksum = (SvnChecksum)childInfo.get(StructureFields.NodeInfo.checksum);
                        boolean conflicted = childInfo.is(StructureFields.NodeInfo.conflicted);
                        this.copyVersionedFile(wcContext, childSrcPath, childDstPath, dstOpRoot, tmpDir, checksum, metadataOnly, conflicted, false);
                    }
                } else if (childKind == ISVNWCDb.SVNWCDbKind.Dir) {
                    this.copyVersionedDirectory(wcContext, childSrcPath, childDstPath, dstOpRoot, tmpDir, metadataOnly, false);
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "cannot handle node kind for ''{0}''", (Object)childSrcPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else if (childStatus == ISVNWCDb.SVNWCDbStatus.Deleted || childStatus == ISVNWCDb.SVNWCDbStatus.NotPresent || childStatus == ISVNWCDb.SVNWCDbStatus.Excluded) {
                wcContext.getDb().opCopy(childSrcPath, childDstPath, null);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot copy ''{0}'' excluded by server", (Object)childSrcPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            childInfo.release();
            if (diskChildren == null || childStatus != ISVNWCDb.SVNWCDbStatus.Normal && childStatus != ISVNWCDb.SVNWCDbStatus.Added) continue;
            diskChildren.remove(childName);
        }
        if (diskChildren != null && !diskChildren.isEmpty()) {
            for (String childName : diskChildren) {
                this.checkCancelled();
                childSrcPath = SVNFileUtil.createFilePath(source, childName);
                childDstPath = SVNFileUtil.createFilePath(dst, childName);
                File tmp = this.copyToTmpDir(childSrcPath, tmpDir, true);
                if (tmp == null) continue;
                SVNSkel moveItem = wcContext.wqBuildFileMove(SVNFileUtil.getParentFile(dst), tmp, childDstPath);
                this.getWcContext().getDb().addWorkQueue(dst, moveItem);
            }
            this.getWcContext().wqRun(dst);
        }
    }

    private void copyVersionedFile(SVNWCContext wcContext, File source, File dst, File dstOpRoot, File tmpDir, SvnChecksum srcChecksum, boolean metadataOnly, boolean conflicted, boolean notify) throws SVNException {
        if (srcChecksum != null && !wcContext.getDb().checkPristine(dst, srcChecksum)) {
            SvnChecksum md5 = wcContext.getDb().getPristineMD5(source, srcChecksum);
            SVNWCContext.PristineContentsInfo pristine = wcContext.getPristineContents(source, false, true);
            File tempFile = SVNFileUtil.createUniqueFile(tmpDir, dst.getName(), ".tmp", false);
            SVNFileUtil.copyFile(pristine.path, tempFile, false);
            wcContext.getDb().installPristine(tempFile, srcChecksum, md5);
        }
        SVNSkel workItems = null;
        File toCopy = source;
        if (!metadataOnly) {
            File tmpDst;
            if (conflicted) {
                File conflictWorking = null;
                List<SVNConflictDescription> conflicts = wcContext.getDb().readConflicts(source);
                for (SVNConflictDescription conflictDescription : conflicts) {
                    if (!conflictDescription.isTextConflict()) continue;
                    conflictWorking = conflictDescription.getPath();
                    break;
                }
                if (conflictWorking != null && SVNFileType.getType(conflictWorking) == SVNFileType.FILE) {
                    toCopy = conflictWorking;
                }
            }
            if ((tmpDst = this.copyToTmpDir(toCopy, tmpDir, true)) != null) {
                boolean needsLock;
                boolean bl = needsLock = wcContext.getProperty(source, "svn:needs-lock") != null;
                if (needsLock) {
                    SVNFileUtil.setReadonly(tmpDst, false);
                }
                SVNSkel workItem = wcContext.wqBuildFileMove(tmpDst, dst);
                workItems = wcContext.wqMerge(workItems, workItem);
                SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(tmpDst));
                if (kind == SVNNodeKind.FILE && !wcContext.isTextModified(source, false)) {
                    SVNSkel workItem2 = wcContext.wqBuildRecordFileinfo(dst, null);
                    workItems = wcContext.wqMerge(workItems, workItem2);
                }
            }
        }
        wcContext.getDb().opCopy(source, dst, workItems);
        wcContext.wqRun(SVNFileUtil.getParentFile(dst));
        if (notify) {
            SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, SVNEventAction.COPY, null, null, 1L, 1L);
            this.handleEvent(event, -1.0);
        }
    }

    private File copyToTmpDir(File source, File tmpDir, boolean recursive) throws SVNException {
        boolean special;
        SVNFileType sourceType = SVNFileType.getType(source);
        boolean bl = special = sourceType == SVNFileType.SYMLINK;
        if (sourceType == SVNFileType.NONE) {
            return null;
        }
        if (sourceType == SVNFileType.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Source ''{0}'' is unexpected kind", (Object)source);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File dstPath = SVNFileUtil.createUniqueFile(tmpDir, source.getName(), ".tmp", false);
        if (sourceType == SVNFileType.DIRECTORY || special) {
            SVNFileUtil.deleteFile(dstPath);
        }
        if (sourceType == SVNFileType.DIRECTORY) {
            if (recursive) {
                SVNFileUtil.copyDirectory(source, dstPath, true, ((SvnCopy)this.getOperation()).getEventHandler());
            } else {
                SVNFileUtil.ensureDirectoryExists(dstPath);
            }
        } else if (!special) {
            SVNFileUtil.copyFile(source, dstPath, false, false);
        } else {
            SVNFileUtil.createSymlink(dstPath, SVNFileUtil.getSymlinkName(source));
        }
        return dstPath;
    }

    private static class SvnCopyPair {
        File source;
        File dst;
        File dstParent;
        String baseName;

        private SvnCopyPair() {
        }
    }
}

