/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNOS2Util;
import org.tmatesoft.svn.core.internal.wc.ISVNInputFile;
import org.tmatesoft.svn.core.internal.wc.ISVNReturnValueCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNFileUtil {
    private static final String ID_COMMAND;
    private static final String LN_COMMAND;
    public static final String LS_COMMAND;
    private static final String CHMOD_COMMAND;
    private static final String ATTRIB_COMMAND;
    private static final String ENV_COMMAND;
    private static final String STAT_COMMAND;
    public static final boolean logNativeCalls;
    public static final boolean isWindows;
    public static final boolean isOS2;
    public static final boolean isOSX;
    public static final boolean isBSD;
    public static boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isOpenVMS;
    public static final boolean is32Bit;
    public static final boolean is64Bit;
    public static final int STREAM_CHUNK_SIZE = 16384;
    public static final int FILE_CREATION_ATTEMPTS_COUNT;
    public static final OutputStream DUMMY_OUT;
    public static final InputStream DUMMY_IN;
    private static boolean ourUseUnsafeCopyOnly;
    private static boolean ourCopyOnSetWritable;
    private static boolean ourUseNIOCopying;
    private static String nativeEOLMarker;
    private static String ourGroupID;
    private static String ourUserID;
    private static File ourAppDataPath;
    private static String ourAdminDirectoryName;
    private static File ourSystemAppDataPath;
    private static Method ourSetWritableMethod;
    private static Method ourSetExecutableMethod;
    private static volatile boolean ourIsSleepForTimeStamp;
    public static final String BINARY_MIME_TYPE = "application/octet-stream";
    private static String ourTestEditor;
    private static String ourTestMergeTool;
    private static String ourTestFunction;

    public static boolean isCaseInsensitiveFS() {
        return isWindows || isOS2;
    }

    public static synchronized boolean useUnsafeCopyOnly() {
        return ourUseUnsafeCopyOnly;
    }

    public static synchronized void setUseUnsafeCopyOnly(boolean useUnsafeCopyOnly) {
        ourUseUnsafeCopyOnly = useUnsafeCopyOnly;
    }

    public static synchronized boolean useCopyOnSetWritable() {
        return ourCopyOnSetWritable;
    }

    public static synchronized void setUseCopyOnSetWritable(boolean useCopyOnSetWritable) {
        ourCopyOnSetWritable = useCopyOnSetWritable;
    }

    public static synchronized boolean useNIOCopying() {
        return ourUseNIOCopying;
    }

    public static synchronized void setUseNIOCopying(boolean useNIOCopy) {
        ourUseNIOCopying = useNIOCopy;
    }

    public static String getIdCommand() {
        return ID_COMMAND;
    }

    public static String getLnCommand() {
        return LN_COMMAND;
    }

    public static String getLsCommand() {
        return LS_COMMAND;
    }

    public static String getChmodCommand() {
        return CHMOD_COMMAND;
    }

    public static String getAttribCommand() {
        return ATTRIB_COMMAND;
    }

    public static String getEnvCommand() {
        return ENV_COMMAND;
    }

    public static String getStatCommand() {
        return STAT_COMMAND;
    }

    public static File getParentFile(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        path = path.replace(File.separatorChar, '/');
        path = SVNPathUtil.canonicalizePath(path);
        int up = 0;
        while (path.endsWith("/..")) {
            path = SVNPathUtil.removeTail(path);
            ++up;
        }
        for (int i = 0; i < up; ++i) {
            path = SVNPathUtil.removeTail(path);
        }
        path = path.replace('/', File.separatorChar);
        file = new File(path);
        return file.getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws SVNException {
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
            String string = SVNFileUtil.readFile(is);
            return string;
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from file ''{0}'': {1}", file, ioe.getMessage());
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return null;
    }

    public static String readFile(InputStream input) throws IOException {
        byte[] buf = new byte[16384];
        StringBuffer result = new StringBuffer();
        int r = -1;
        while ((r = input.read(buf)) != -1) {
            if (r == 0) continue;
            result.append(new String(buf, 0, r, "UTF-8"));
        }
        return result.toString();
    }

    public static int readIntoBuffer(InputStream is, byte[] buff, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            int r = is.read(buff, off + read, len);
            if (r < 0) {
                if (read != 0) break;
                read = -1;
                break;
            }
            read += r;
            len -= r;
        }
        return read;
    }

    public static String getBasePath(File file) {
        File adminDir;
        File base = SVNFileUtil.getFileDir(file);
        while (!(base == null || base.isDirectory() && (adminDir = new File(base, SVNFileUtil.getAdminDirectoryName())).exists() && adminDir.isDirectory())) {
            base = SVNFileUtil.getFileDir(base);
        }
        String path = file.getAbsolutePath();
        if (base != null) {
            path = path.substring(base.getAbsolutePath().length());
        }
        if ((path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static void createEmptyFile(File file) throws SVNException {
        boolean created;
        if (file != null && SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        IOException ioError = null;
        try {
            created = SVNFileUtil.createNewFile(file);
        }
        catch (IOException ioe) {
            created = false;
            ioError = ioe;
        }
        if (!created) {
            SVNErrorMessage err = null;
            err = ioError != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new file ''{0}'': {1}", file, ioError.getMessage()) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create new file ''{0}''", (Object)file);
            SVNErrorManager.error(err, ioError != null ? ioError : new Exception(), Level.FINE, SVNLogType.WC);
        }
    }

    public static boolean createNewFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        boolean created = false;
        long sleep = 1L;
        for (int count = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1; !created && count > 0; --count) {
            IOException ioError = null;
            try {
                created = file.createNewFile();
            }
            catch (IOException e) {
                ioError = e;
            }
            if (ioError != null) {
                if (count == 1) {
                    throw ioError;
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ie) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, ie, Level.FINEST);
                }
                if (sleep < 128L) {
                    sleep *= 2L;
                }
            }
            if (ioError != null || created) continue;
            return false;
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(File file, String contents, String charSet) throws SVNException {
        SVNFileUtil.createEmptyFile(file);
        if (contents == null || contents.length() == 0) {
            return;
        }
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(file);
            if (charSet != null) {
                os.write(contents.getBytes(charSet));
            } else {
                os.write(contents.getBytes());
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}'': {1}", file, ioe.getMessage());
            SVNErrorManager.error(err, ioe, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}''", (Object)file);
            SVNErrorManager.error(err, svne, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String contents, String charSet) throws SVNException {
        if (contents == null || contents.length() == 0) {
            return;
        }
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(file);
            if (charSet != null) {
                os.write(contents.getBytes(charSet));
            } else {
                os.write(contents.getBytes());
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}'': {1}", file, ioe.getMessage());
            SVNErrorManager.error(err, ioe, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to file ''{0}''", (Object)file);
            SVNErrorManager.error(err, svne, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVersionFile(File file, int version) throws SVNException {
        if (version < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Version {0} is not non-negative", (Object)new Integer(version));
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        String contents = version + "\n";
        File tmpFile = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file), SVNFileUtil.getFileName(file), ".tmp", false);
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(tmpFile);
            os.write(contents.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        if (isWindows) {
            SVNFileUtil.setReadonly(file, false);
        }
        SVNFileUtil.rename(tmpFile, file);
        SVNFileUtil.setReadonly(file, true);
    }

    public static synchronized File createUniqueFile(File parent, String name, String suffix, boolean useUUIDGenerator) throws SVNException {
        StringBuffer fileName = new StringBuffer();
        fileName.append(name);
        if (useUUIDGenerator) {
            fileName.append(".");
            fileName.append(SVNUUIDGenerator.generateUUIDString());
        }
        fileName.append(suffix);
        File file = new File(parent, fileName.toString());
        int i = 2;
        do {
            if (SVNFileType.getType(file) == SVNFileType.NONE) {
                SVNFileUtil.createEmptyFile(file);
                return file;
            }
            fileName.setLength(0);
            fileName.append(name);
            fileName.append(".");
            if (useUUIDGenerator) {
                fileName.append(SVNUUIDGenerator.generateUUIDString());
            } else {
                fileName.append(i);
            }
            fileName.append(suffix);
            file = new File(parent, fileName.toString());
        } while (++i < 99999);
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to make name for ''{0}''", (Object)new File(parent, name));
        SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        return null;
    }

    public static synchronized File createUniqueDir(File parent, String name, String suffix, boolean useUUIDGenerator) throws SVNException {
        StringBuffer fileName = new StringBuffer();
        fileName.append(name);
        if (useUUIDGenerator) {
            fileName.append(".");
            fileName.append(SVNUUIDGenerator.generateUUIDString());
        }
        fileName.append(suffix);
        File file = new File(parent, fileName.toString());
        int i = 2;
        do {
            if (SVNFileType.getType(file) == SVNFileType.NONE) {
                file.mkdir();
                return file;
            }
            fileName.setLength(0);
            fileName.append(name);
            fileName.append(".");
            if (useUUIDGenerator) {
                fileName.append(SVNUUIDGenerator.generateUUIDString());
            } else {
                fileName.append(i);
            }
            fileName.append(suffix);
            file = new File(parent, fileName.toString());
        } while (++i < 99999);
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_UNIQUE_NAMES_EXHAUSTED, "Unable to make name for ''{0}''", (Object)new File(parent, name));
        SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        return null;
    }

    public static void moveFile(File src, File dst) throws SVNException {
        File tmpPath = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(dst), SVNFileUtil.getFileName(src), "tmp", false);
        try {
            SVNFileUtil.copyFile(src, tmpPath, true);
        }
        catch (SVNException ex) {
            try {
                SVNFileUtil.deleteFile(tmpPath);
            }
            catch (SVNException ex2) {
                // empty catch block
            }
            throw ex;
        }
        try {
            SVNFileUtil.rename(tmpPath, dst);
        }
        catch (SVNException ex) {
            try {
                SVNFileUtil.deleteFile(tmpPath);
            }
            catch (SVNException ex2) {
                // empty catch block
            }
            throw ex;
        }
        try {
            SVNFileUtil.deleteFile(src);
        }
        catch (SVNException ex) {
            try {
                SVNFileUtil.deleteFile(dst);
            }
            catch (SVNException ex2) {
                // empty catch block
            }
            throw ex;
        }
    }

    public static void moveDir(File src, File dst) throws SVNException {
        File tmpPath = SVNFileUtil.createUniqueDir(SVNFileUtil.getFileDir(dst), SVNFileUtil.getFileName(src), "tmp", false);
        try {
            SVNFileUtil.copyDirectory(src, tmpPath, false, null);
        }
        catch (SVNException ex) {
            SVNFileUtil.deleteAll(tmpPath, true);
            throw ex;
        }
        try {
            SVNFileUtil.rename(tmpPath, dst);
        }
        catch (SVNException ex) {
            SVNFileUtil.deleteAll(tmpPath, true);
            throw ex;
        }
        try {
            SVNFileUtil.deleteAll(src, true, null);
        }
        catch (SVNException ex) {
            SVNFileUtil.deleteAll(dst, true);
            throw ex;
        }
    }

    public static void rename(File src, File dst) throws SVNException {
        if (SVNFileType.getType(src) == SVNFileType.NONE) {
            SVNFileUtil.deleteFile(dst);
            return;
        }
        boolean renamed = false;
        if (!isWindows) {
            renamed = src.renameTo(dst);
            if (!renamed && src.isFile() && !dst.exists()) {
                boolean deleted;
                SVNFileUtil.copyFile(src, dst, true);
                if (!dst.isFile()) {
                    SVNFileUtil.copyFile(src, dst, false);
                }
                renamed = (deleted = SVNFileUtil.deleteFile(src)) && dst.isFile();
            }
        } else {
            if (isOS2) {
                if (SVNOS2Util.moveFile(src, dst)) {
                    renamed = true;
                }
            } else if (SVNJNAUtil.moveFile(src, dst)) {
                renamed = true;
            }
            if (!renamed) {
                boolean caseOnly = dst.getAbsolutePath().equalsIgnoreCase(src.getAbsolutePath());
                boolean wasRO = dst.exists() && !dst.canWrite();
                SVNFileUtil.setReadonly(src, false);
                if (!caseOnly) {
                    SVNFileUtil.setReadonly(dst, false);
                }
                if (src.renameTo(dst)) {
                    return;
                }
                long sleep = 1L;
                for (int i = 0; i < FILE_CREATION_ATTEMPTS_COUNT; ++i) {
                    if (!caseOnly) {
                        dst.delete();
                    }
                    if (src.renameTo(dst)) {
                        if (wasRO && !isOpenVMS) {
                            dst.setReadOnly();
                        }
                        return;
                    }
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (sleep >= 128L) continue;
                    sleep *= 2L;
                }
            }
        }
        if (!renamed) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot rename file ''{0}'' to ''{1}''", src, dst);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setReadonly(File file, boolean readonly) {
        block18: {
            if (!file.exists()) {
                return false;
            }
            if (isOpenVMS) {
                return true;
            }
            if (readonly) {
                return file.setReadOnly();
            }
            if (ourSetWritableMethod != null) {
                try {
                    Object result = ourSetWritableMethod.invoke((Object)file, Boolean.TRUE);
                    if (Boolean.TRUE.equals(result)) {
                        return true;
                    }
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (isOS2 ? SVNOS2Util.setWritable(file) : (isWindows ? SVNJNAUtil.setWritable(file) : (isLinux || isOSX || isBSD || isSolaris) && SVNJNAUtil.setWritable(file))) {
                return true;
            }
            try {
                SVNFileType fileType = SVNFileType.getType(file);
                if (fileType == SVNFileType.FILE && SVNFileUtil.useCopyOnSetWritable() && file.length() < 102400L) {
                    File tmp = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(file), SVNFileUtil.getFileName(file), ".ro", true);
                    SVNFileUtil.copyFile(file, tmp, false);
                    SVNFileUtil.copyFile(tmp, file, false);
                    SVNFileUtil.deleteFile(tmp);
                    break block18;
                }
                if (isWindows) {
                    Process p = null;
                    try {
                        p = Runtime.getRuntime().exec(ATTRIB_COMMAND + " -R \"" + file.getAbsolutePath() + "\"");
                        p.waitFor();
                        break block18;
                    }
                    finally {
                        if (p != null) {
                            SVNFileUtil.closeFile(p.getInputStream());
                            SVNFileUtil.closeFile(p.getOutputStream());
                            SVNFileUtil.closeFile(p.getErrorStream());
                            p.destroy();
                        }
                    }
                }
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, "ugo+w", file.getAbsolutePath()});
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
                return false;
            }
        }
        return true;
    }

    public static void setExecutable(File file, boolean executable) {
        if (isWindows || isOpenVMS || file == null || !file.exists() || SVNFileType.getType(file) == SVNFileType.SYMLINK) {
            return;
        }
        if (ourSetExecutableMethod != null) {
            try {
                ourSetExecutableMethod.invoke((Object)file, executable, Boolean.FALSE);
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (SVNJNAUtil.setExecutable(file, executable)) {
            return;
        }
        try {
            if (file.canWrite()) {
                SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, executable ? "ugo+x" : "ugo-x", file.getAbsolutePath()});
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
    }

    public static boolean symlinksSupported() {
        return !isWindows && !isOpenVMS && SVNFileType.isSymlinkSupportEnabled();
    }

    public static void setSGID(File dir) {
        if (isWindows || isOpenVMS || dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        if (SVNJNAUtil.setSGID(dir)) {
            return;
        }
        try {
            SVNFileUtil.execCommand(new String[]{CHMOD_COMMAND, "g+s", dir.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
    }

    public static File resolveSymlinkToFile(File file) {
        if (!SVNFileUtil.symlinksSupported()) {
            return null;
        }
        File targetFile = SVNFileUtil.resolveSymlink(file);
        if (targetFile == null || !targetFile.isFile()) {
            return null;
        }
        return targetFile;
    }

    public static File resolveSymlink(File file) {
        if (!SVNFileUtil.symlinksSupported()) {
            return null;
        }
        File targetFile = file;
        while (SVNFileType.getType(targetFile) == SVNFileType.SYMLINK) {
            String symlinkName = SVNFileUtil.getSymlinkName(targetFile);
            if (symlinkName == null) {
                return null;
            }
            if (symlinkName.startsWith("/")) {
                targetFile = new File(symlinkName);
                continue;
            }
            targetFile = new File(SVNFileUtil.getFileDir(targetFile), symlinkName);
        }
        return targetFile;
    }

    public static void copy(File src, File dst, boolean safe, boolean copyAdminDirectories) throws SVNException {
        String name;
        SVNFileType srcType = SVNFileType.getType(src);
        if (srcType == SVNFileType.FILE) {
            SVNFileUtil.copyFile(src, dst, safe);
        } else if (srcType == SVNFileType.DIRECTORY) {
            SVNFileUtil.copyDirectory(src, dst, copyAdminDirectories, null);
        } else if (srcType == SVNFileType.SYMLINK && (name = SVNFileUtil.getSymlinkName(src)) != null) {
            SVNFileUtil.createSymlink(dst, name);
        }
    }

    public static void copyFile(File src, File dst, boolean safe) throws SVNException {
        SVNFileUtil.copyFile(src, dst, safe, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst, boolean safe, boolean keepTimestamp) throws SVNException {
        if (src == null || dst == null) {
            return;
        }
        if (src.equals(dst)) {
            return;
        }
        if (!src.exists()) {
            dst.delete();
            return;
        }
        File tmpDst = dst;
        if (SVNFileType.getType(dst) != SVNFileType.NONE) {
            if (safe && !SVNFileUtil.useUnsafeCopyOnly()) {
                tmpDst = SVNFileUtil.createUniqueFile(SVNFileUtil.getFileDir(dst), ".copy", ".tmp", true);
            } else {
                dst.delete();
            }
        }
        boolean executable = SVNFileUtil.isExecutable(src);
        SVNFileUtil.getFileDir(dst).mkdirs();
        SVNErrorMessage error = null;
        boolean useNIO = SVNFileUtil.useNIOCopying();
        if (useNIO) {
            FileChannel srcChannel = null;
            AbstractInterruptibleChannel dstChannel = null;
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                long totalSize;
                is = SVNFileUtil.createFileInputStream(src);
                srcChannel = is.getChannel();
                os = SVNFileUtil.createFileOutputStream(tmpDst, false);
                dstChannel = os.getChannel();
                for (long toCopy = totalSize = srcChannel.size(); toCopy > 0L; toCopy -= ((FileChannel)dstChannel).transferFrom(srcChannel, totalSize - toCopy, toCopy)) {
                }
            }
            catch (IOException e) {
                error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", src, dst, e.getLocalizedMessage());
            }
            finally {
                if (srcChannel != null) {
                    try {
                        srcChannel.close();
                    }
                    catch (IOException e) {}
                }
                if (dstChannel != null) {
                    try {
                        dstChannel.close();
                    }
                    catch (IOException e) {}
                }
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(os);
            }
        }
        if (!useNIO || error != null) {
            error = null;
            InputStream sis = null;
            OutputStream dos = null;
            try {
                sis = SVNFileUtil.openFileForReading(src, SVNLogType.WC);
                dos = SVNFileUtil.openFileForWriting(tmpDst);
                SVNTranslator.copy(sis, dos);
            }
            catch (IOException e) {
                try {
                    error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy file ''{0}'' to ''{1}'': {2}", src, dst, e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(dos);
                    SVNFileUtil.closeFile(sis);
                    throw throwable;
                }
                SVNFileUtil.closeFile(dos);
                SVNFileUtil.closeFile(sis);
            }
            SVNFileUtil.closeFile(dos);
            SVNFileUtil.closeFile(sis);
        }
        if (error != null) {
            SVNErrorManager.error(error, Level.FINE, SVNLogType.WC);
        }
        if (safe && tmpDst != dst) {
            SVNFileUtil.rename(tmpDst, dst);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dst, true);
        }
        if (keepTimestamp) {
            SVNFileUtil.setLastModified(dst, src.lastModified());
        }
    }

    public static boolean setLastModified(File file, long timestamp) {
        if (file != null && timestamp >= 0L) {
            return file.setLastModified(timestamp);
        }
        return false;
    }

    public static boolean createSymlink(File link, File linkName) throws SVNException {
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNFileType.getType(link) != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create symbolic link ''{0}''; file already exists", (Object)link);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        String fileContents = "";
        try {
            fileContents = SVNFileUtil.readSingleLine(linkName);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        if (fileContents.startsWith("link ")) {
            fileContents = fileContents.substring("link".length()).trim();
            return SVNFileUtil.createSymlink(link, fileContents);
        }
        SVNFileUtil.createFile(link, fileContents, "UTF-8");
        return true;
    }

    public static boolean createSymlink(File link, String linkName) {
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNJNAUtil.createSymlink(link, linkName)) {
            return true;
        }
        try {
            SVNFileUtil.execCommand(new String[]{LN_COMMAND, "-s", linkName, link.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
        return SVNFileType.getType(link) == SVNFileType.SYMLINK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean detranslateSymlink(File src, File linkFile) throws SVNException {
        String linkPath;
        if (!SVNFileUtil.symlinksSupported()) {
            return false;
        }
        if (SVNFileType.getType(src) != SVNFileType.SYMLINK) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        if ((linkPath = SVNFileUtil.getSymlinkName(src)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot detranslate symbolic link ''{0}''; file does not exist or not a symbolic link", (Object)src);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        OutputStream os = SVNFileUtil.openFileForWriting(linkFile);
        try {
            os.write("link ".getBytes("UTF-8"));
            os.write(linkPath.getBytes("UTF-8"));
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(os);
        }
        return true;
    }

    public static String getSymlinkName(File link) {
        if (!SVNFileUtil.symlinksSupported() || link == null) {
            return null;
        }
        String ls = null;
        ls = SVNJNAUtil.getLinkTarget(link);
        if (ls != null) {
            return ls;
        }
        try {
            ls = SVNFileUtil.execCommand(new String[]{LS_COMMAND, "-ld", link.getAbsolutePath()});
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
        if (ls == null || ls.lastIndexOf(" -> ") < 0) {
            return null;
        }
        int index = ls.lastIndexOf(" -> ") + " -> ".length();
        if (index <= ls.length()) {
            return ls.substring(index);
        }
        return null;
    }

    public static String computeChecksum(String line) {
        MessageDigest digest;
        if (line == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        if (digest == null) {
            return null;
        }
        digest.update(line.getBytes());
        return SVNFileUtil.toHexDigest(digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeChecksum(File file) throws SVNException {
        MessageDigest digest;
        if (file == null || file.isDirectory() || !file.exists()) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
            return null;
        }
        InputStream is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
        byte[] buffer = new byte[16384];
        try {
            int l;
            while ((l = is.read(buffer)) >= 0) {
                if (l == 0) continue;
                digest.update(buffer, 0, l);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return SVNFileUtil.toHexDigest(digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFiles(File f1, File f2, MessageDigest digest) throws SVNException {
        if (f1 == null || f2 == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "NULL paths are supported in compareFiles method");
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
            return false;
        }
        if (f1.equals(f2)) {
            return true;
        }
        boolean equals = true;
        if (f1.length() != f2.length()) {
            if (digest == null) {
                return false;
            }
            equals = false;
        }
        InputStream is1 = SVNFileUtil.openFileForReading(f1, SVNLogType.WC);
        InputStream is2 = SVNFileUtil.openFileForReading(f2, SVNLogType.WC);
        try {
            while (true) {
                int b2;
                int b1;
                if ((b1 = is1.read()) != (b2 = is2.read())) {
                    if (digest == null) {
                        boolean bl = false;
                        return bl;
                    }
                    equals = false;
                }
                if (b1 < 0) {
                    break;
                }
                if (digest == null) continue;
                digest.update((byte)(b1 & 0xFF));
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
        }
        return equals;
    }

    public static void truncate(File file, long truncateToSize) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = SVNFileUtil.openRAFileForWriting(file, false);
            raf.setLength(truncateToSize);
        }
        catch (SVNException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            SVNFileUtil.closeFile(raf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHidden(File file, boolean hidden) {
        if (isOS2 && SVNOS2Util.setHidden(file, hidden)) {
            return;
        }
        if (isWindows && SVNJNAUtil.setHidden(file)) {
            return;
        }
        if (!isWindows || file == null || !file.exists() || file.isHidden()) {
            return;
        }
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
        finally {
            if (p != null) {
                SVNFileUtil.closeFile(p.getErrorStream());
                SVNFileUtil.closeFile(p.getInputStream());
                SVNFileUtil.closeFile(p.getOutputStream());
                p.destroy();
            }
        }
    }

    public static void deleteAll(File dir, ISVNEventHandler cancelBaton) throws SVNException {
        SVNFileUtil.deleteAll(dir, true, cancelBaton);
    }

    public static void deleteAll(File dir, boolean deleteDirs) {
        try {
            SVNFileUtil.deleteAll(dir, deleteDirs, null);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    public static void deleteAll(File dir, boolean deleteDirs, ISVNCanceller cancelBaton) throws SVNException {
        File[] children;
        if (dir == null) {
            return;
        }
        SVNFileType fileType = SVNFileType.getType(dir);
        File[] fileArray = children = fileType == SVNFileType.DIRECTORY ? SVNFileListUtil.listFiles(dir) : null;
        if (children != null) {
            if (cancelBaton != null) {
                cancelBaton.checkCancelled();
            }
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                SVNFileUtil.deleteAll(child, deleteDirs, cancelBaton);
            }
            if (cancelBaton != null) {
                cancelBaton.checkCancelled();
            }
        }
        if (fileType == SVNFileType.DIRECTORY && !deleteDirs) {
            return;
        }
        SVNFileUtil.deleteFile(dir);
    }

    public static boolean deleteFile(File file) throws SVNException {
        if (file == null) {
            return true;
        }
        if (!isWindows || file.isDirectory() || !file.exists()) {
            return file.delete();
        }
        long sleep = 1L;
        for (int i = 0; i < FILE_CREATION_ATTEMPTS_COUNT; ++i) {
            if (file.delete() && !file.exists()) {
                return true;
            }
            if (!file.exists()) {
                return true;
            }
            SVNFileUtil.setReadonly(file, false);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (sleep >= 128L) continue;
            sleep *= 2L;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot delete file ''{0}''", (Object)file);
        SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        return false;
    }

    public static String toHexDigest(MessageDigest digest) {
        if (digest == null) {
            return null;
        }
        byte[] result = digest.digest();
        StringBuffer hexDigest = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            SVNFormatUtil.appendHexNumber(hexDigest, result[i]);
        }
        return hexDigest.toString();
    }

    public static String toHexDigest(byte[] digest) {
        if (digest == null) {
            return null;
        }
        StringBuffer hexDigest = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            SVNFormatUtil.appendHexNumber(hexDigest, digest[i]);
        }
        return hexDigest.toString();
    }

    public static byte[] fromHexDigest(String hexDigest) {
        if (hexDigest == null || hexDigest.length() == 0) {
            return null;
        }
        int digestLength = (hexDigest = hexDigest.toLowerCase()).length() / 2;
        if (digestLength == 0 || 2 * digestLength != hexDigest.length()) {
            return null;
        }
        byte[] digest = new byte[digestLength];
        for (int i = 0; i < hexDigest.length() / 2; ++i) {
            byte b;
            if (!SVNFileUtil.isHex(hexDigest.charAt(2 * i)) || !SVNFileUtil.isHex(hexDigest.charAt(2 * i + 1))) {
                return null;
            }
            int hi = Character.digit(hexDigest.charAt(2 * i), 16) << 4;
            int lo = Character.digit(hexDigest.charAt(2 * i + 1), 16);
            Integer ib = new Integer(hi | lo);
            digest[i] = b = ib.byteValue();
        }
        return digest;
    }

    public static String getNativeEOLMarker(ISVNOptions options) {
        if (nativeEOLMarker == null) {
            nativeEOLMarker = new String(options.getNativeEOL());
        }
        return nativeEOLMarker;
    }

    public static long roundTimeStamp(long tstamp) {
        return tstamp / 1000L * 1000L;
    }

    public static void sleepForTimestamp() {
        if (!ourIsSleepForTimeStamp) {
            return;
        }
        long time = System.currentTimeMillis();
        time = 1100L - (time - time / 1000L * 1000L);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setSleepForTimestamp(boolean sleep) {
        ourIsSleepForTimeStamp = sleep;
    }

    public static String readLineFromStream(InputStream is, StringBuffer buffer, CharsetDecoder decoder) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int r = -1;
        while ((r = is.read()) != 10) {
            if (r == -1) {
                String out = SVNFileUtil.decode(decoder, byteBuffer.toByteArray());
                buffer.append(out);
                return null;
            }
            byteBuffer.write(r);
        }
        String out = SVNFileUtil.decode(decoder, byteBuffer.toByteArray());
        buffer.append(out);
        return out;
    }

    public static String detectMimeType(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int read = SVNFileUtil.readIntoBuffer(is, buffer, 0, buffer.length);
        int binaryCount = 0;
        for (int i = 0; i < read; ++i) {
            byte b = buffer[i];
            if (b == 0) {
                return BINARY_MIME_TYPE;
            }
            if (b >= 7 && (b <= 13 || b >= 32) && b <= 127) continue;
            ++binaryCount;
        }
        if (read > 0 && binaryCount * 1000 / read > 850) {
            return BINARY_MIME_TYPE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectMimeType(File file, Map<String, String> mimeTypes) throws SVNException {
        String pathExt;
        if (file == null || !file.exists()) {
            return null;
        }
        SVNFileType kind = SVNFileType.getType(file);
        if (kind != SVNFileType.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Can''t detect MIME type of non-file ''{0}''", (Object)file);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        if (mimeTypes != null) {
            String mimeType;
            String name = SVNFileUtil.getFileName(file);
            pathExt = "";
            int dotInd = name.lastIndexOf(46);
            if (dotInd != -1 && dotInd != 0 && dotInd != name.length() - 1) {
                pathExt = name.substring(dotInd + 1);
            }
            if ((mimeType = mimeTypes.get(pathExt)) != null) {
                return mimeType;
            }
        }
        InputStream is = null;
        try {
            is = SVNFileUtil.openFileForReading(file, SVNLogType.WC);
            pathExt = SVNFileUtil.detectMimeType(is);
            return pathExt;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (SVNException e) {
            String string = null;
            return string;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
    }

    public static boolean isExecutable(File file) throws SVNException {
        if (isWindows || isOpenVMS) {
            return false;
        }
        Boolean executable = SVNJNAUtil.isExecutable(file);
        if (executable != null) {
            return executable;
        }
        String[] commandLine = new String[]{LS_COMMAND, "-ln", file.getAbsolutePath()};
        String line = null;
        try {
            if (file.canRead()) {
                line = SVNFileUtil.execCommand(commandLine);
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
        }
        if (line == null || line.indexOf(32) < 0) {
            return false;
        }
        int index = 0;
        String mod = null;
        String fuid = null;
        String fgid = null;
        StringTokenizer tokens = new StringTokenizer(line, " \t");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (index == 0) {
                mod = token;
            } else if (index == 2) {
                fuid = token;
            } else if (index == 3) {
                fgid = token;
            } else if (index > 3) break;
            ++index;
        }
        if (mod == null) {
            return false;
        }
        if (SVNFileUtil.getCurrentUser().equals(fuid)) {
            return mod.toLowerCase().indexOf(120) >= 0 && mod.toLowerCase().indexOf(120) < 4;
        }
        if (SVNFileUtil.getCurrentGroup().equals(fgid)) {
            return mod.toLowerCase().indexOf(120, 4) >= 4 && mod.toLowerCase().indexOf(120, 4) < 7;
        }
        return mod.toLowerCase().indexOf(120, 7) >= 7;
    }

    public static File ensureDirectoryExists(File path) throws SVNException {
        boolean created;
        SVNFileType type = SVNFileType.getType(path);
        SVNNodeKind kind = SVNFileType.getNodeKind(type);
        if (kind != SVNNodeKind.NONE && kind != SVNNodeKind.DIR) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' is not a directory", (Object)path);
            SVNErrorManager.error(error, SVNLogType.WC);
        } else if (kind == SVNNodeKind.NONE && !(created = path.mkdirs())) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Unable to make directories", (Object)path);
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        return path;
    }

    public static void copyDirectory(File srcDir, File dstDir, boolean copyAdminDir, ISVNEventHandler cancel) throws SVNException {
        if (!dstDir.exists()) {
            dstDir.mkdirs();
            SVNFileUtil.setLastModified(dstDir, srcDir.lastModified());
        }
        File[] files = SVNFileListUtil.listFiles(srcDir);
        for (int i = 0; files != null && i < files.length; ++i) {
            String name;
            File file = files[i];
            if (SVNFileUtil.getFileName(file).equals("..") || SVNFileUtil.getFileName(file).equals(".") || file.equals(dstDir)) continue;
            if (cancel != null) {
                cancel.checkCancelled();
            }
            if (!copyAdminDir && SVNFileUtil.getFileName(file).equals(SVNFileUtil.getAdminDirectoryName())) continue;
            SVNFileType fileType = SVNFileType.getType(file);
            File dst = new File(dstDir, SVNFileUtil.getFileName(file));
            if (fileType == SVNFileType.FILE) {
                boolean executable = SVNFileUtil.isExecutable(file);
                SVNFileUtil.copyFile(file, dst, false);
                if (!executable) continue;
                SVNFileUtil.setExecutable(dst, executable);
                continue;
            }
            if (fileType == SVNFileType.DIRECTORY) {
                SVNFileUtil.copyDirectory(file, dst, copyAdminDir, cancel);
                if (!file.isHidden() && !SVNFileUtil.getAdminDirectoryName().equals(SVNFileUtil.getFileName(file))) continue;
                SVNFileUtil.setHidden(dst, true);
                continue;
            }
            if (fileType != SVNFileType.SYMLINK || (name = SVNFileUtil.getSymlinkName(file)) == null) continue;
            SVNFileUtil.createSymlink(dst, name);
        }
    }

    public static OutputStream openFileForWriting(File file) throws SVNException {
        return SVNFileUtil.openFileForWriting(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream openFileForWriting(File file, boolean append) throws SVNException {
        if (file == null) {
            return null;
        }
        if (SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        if (isOpenVMS && !append && file.isFile()) {
            SVNFileUtil.deleteFile(file);
        } else if (file.isFile() && !file.canWrite()) {
            SVNFileUtil.setReadonly(file, false);
        }
        FileOutputStream fos = null;
        BufferedOutputStream result = null;
        try {
            fos = SVNFileUtil.createFileOutputStream(file, append);
            result = new BufferedOutputStream(fos);
        }
        catch (IOException e) {
            SVNFileUtil.closeFile(fos);
            SVNFileUtil.closeFile(result);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", file, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            if (result == null) {
                SVNFileUtil.closeFile(fos);
            }
        }
        return result;
    }

    public static FileOutputStream createFileOutputStream(File file, boolean append) throws IOException {
        int retryCount = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1;
        FileOutputStream os = null;
        long sleep = 1L;
        for (int i = 0; i < retryCount; ++i) {
            try {
                os = new FileOutputStream(file, append);
                break;
            }
            catch (IOException e) {
                SVNFileUtil.closeFile(os);
                if (i + 1 >= retryCount) {
                    throw e;
                }
                if (file.exists() && file.isFile() && file.canWrite()) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (sleep >= 128L) continue;
                    sleep *= 2L;
                    continue;
                }
                throw e;
            }
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessFile openRAFileForWriting(File file, boolean append) throws SVNException {
        if (file == null) {
            return null;
        }
        if (SVNFileUtil.getFileDir(file) != null && !SVNFileUtil.getFileDir(file).exists()) {
            SVNFileUtil.getFileDir(file).mkdirs();
        }
        RandomAccessFile raf = null;
        RandomAccessFile result = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            if (append) {
                raf.seek(raf.length());
            }
            result = raf;
        }
        catch (FileNotFoundException e) {
            SVNFileUtil.closeFile(raf);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to file ''{0}'': {1}", file, e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        catch (IOException ioe) {
            SVNFileUtil.closeFile(raf);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not set position pointer in file ''{0}'': {1}", file, ioe.getMessage());
            SVNErrorManager.error(err, ioe, Level.FINE, SVNLogType.DEFAULT);
        }
        finally {
            if (result == null) {
                SVNFileUtil.closeFile(raf);
            }
        }
        return result;
    }

    public static InputStream openFileForReading(File file) throws SVNException {
        return SVNFileUtil.openFileForReading(file, Level.FINE, SVNLogType.DEFAULT);
    }

    public static InputStream openFileForReading(File file, SVNLogType logType) throws SVNException {
        return SVNFileUtil.openFileForReading(file, Level.FINE, logType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openFileForReading(File file, Level logLevel, SVNLogType logType) throws SVNException {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream result = null;
        try {
            fis = SVNFileUtil.createFileInputStream(file);
            result = new BufferedInputStream(fis);
        }
        catch (FileNotFoundException nfe) {
            SVNFileUtil.closeFile(fis);
            SVNFileUtil.closeFile(result);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, nfe.getMessage());
            SVNErrorManager.error(err, logLevel, logType);
        }
        catch (IOException e) {
            SVNFileUtil.closeFile(fis);
            SVNFileUtil.closeFile(result);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, e.getMessage());
            SVNErrorManager.error(err, e, logLevel, logType);
        }
        finally {
            if (result == null) {
                SVNFileUtil.closeFile(fis);
            }
        }
        return result;
    }

    public static FileInputStream createFileInputStream(File file) throws IOException {
        int retryCount = isWindows ? FILE_CREATION_ATTEMPTS_COUNT : 1;
        FileInputStream is = null;
        long sleep = 1L;
        for (int i = 0; i < retryCount; ++i) {
            try {
                is = new FileInputStream(file);
                break;
            }
            catch (IOException e) {
                SVNFileUtil.closeFile(is);
                if (i + 1 >= retryCount) {
                    throw e;
                }
                if (file.exists() && file.isFile() && file.canRead()) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (sleep >= 128L) continue;
                    sleep *= 2L;
                    continue;
                }
                throw e;
            }
        }
        return is;
    }

    public static RandomAccessFile openRAFileForReading(File file) throws SVNException {
        SVNErrorMessage err;
        if (file == null) {
            return null;
        }
        if (!file.isFile() || !file.canRead()) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': path refers to a directory or read access is denied", (Object)file);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        if (!file.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "File ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
        }
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from ''{0}'': {1}", file, e.getMessage());
            SVNErrorManager.error(err2, Level.FINE, SVNLogType.WC);
            return null;
        }
    }

    public static void closeFile(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(ISVNInputFile inFile) {
        if (inFile == null) {
            return;
        }
        try {
            inFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeFile(RandomAccessFile raf) {
        if (raf == null) {
            return;
        }
        try {
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String execCommand(String[] commandLine) throws SVNException {
        return SVNFileUtil.execCommand(commandLine, false, null);
    }

    public static String execCommand(String[] commandLine, boolean waitAfterRead, ISVNReturnValueCallback callback) throws SVNException {
        return SVNFileUtil.execCommand(commandLine, null, waitAfterRead, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String execCommand(String[] commandLine, String[] env, boolean waitAfterRead, ISVNReturnValueCallback callback) throws SVNException {
        String string;
        Process process;
        StringBuffer result;
        boolean handleOutput;
        InputStream is;
        block13: {
            int r;
            block12: {
                is = null;
                handleOutput = callback != null && callback.isHandleProgramOutput();
                result = handleOutput ? null : new StringBuffer();
                process = null;
                process = Runtime.getRuntime().exec(commandLine, env);
                is = process.getInputStream();
                if (waitAfterRead) break block12;
                int rc = process.waitFor();
                if (callback != null) {
                    callback.handleReturnValue(rc);
                }
                if (rc == 0) break block12;
                String string2 = null;
                SVNFileUtil.closeFile(is);
                if (process == null) return string2;
                process.destroy();
                return string2;
            }
            while ((r = is.read()) >= 0) {
                char ch = (char)(r & 0xFF);
                if (handleOutput) {
                    callback.handleChar(ch);
                    continue;
                }
                result.append(ch);
            }
            if (!waitAfterRead) break block13;
            int rc = process.waitFor();
            if (callback != null) {
                callback.handleReturnValue(rc);
            }
            if (rc == 0) break block13;
            String string3 = null;
            SVNFileUtil.closeFile(is);
            if (process == null) return string3;
            process.destroy();
            return string3;
        }
        try {
            string = handleOutput ? null : result.toString().trim();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, e);
            SVNFileUtil.closeFile(is);
            if (process == null) return null;
            process.destroy();
            return null;
        }
        catch (InterruptedException e2) {
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, e2);
            {
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(is);
                    if (process == null) throw throwable;
                    process.destroy();
                    throw throwable;
                }
            }
            SVNFileUtil.closeFile(is);
            if (process == null) return null;
            process.destroy();
            return null;
        }
        SVNFileUtil.closeFile(is);
        if (process == null) return string;
        process.destroy();
        return string;
    }

    public static void closeFile(Writer os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeFile(Reader is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getAdminDirectoryName() {
        if (ourAdminDirectoryName == null) {
            String defaultAdminDir = ".svn";
            if (SVNFileUtil.getEnvironmentVariable("SVN_ASP_DOT_NET_HACK") != null) {
                defaultAdminDir = "_svn";
            }
            if ((ourAdminDirectoryName = System.getProperty("svnkit.admindir", System.getProperty("javasvn.admindir", defaultAdminDir))) == null || "".equals(ourAdminDirectoryName.trim())) {
                ourAdminDirectoryName = defaultAdminDir;
            }
        }
        return ourAdminDirectoryName;
    }

    public static void setAdminDirectoryName(String name) {
        ourAdminDirectoryName = name;
    }

    public static File getApplicationDataPath() {
        if (ourAppDataPath != null) {
            return ourAppDataPath;
        }
        String jnaAppData = SVNJNAUtil.getApplicationDataPath(false);
        if (jnaAppData != null) {
            ourAppDataPath = new File(jnaAppData);
            return ourAppDataPath;
        }
        String envAppData = SVNFileUtil.getEnvironmentVariable("APPDATA");
        ourAppDataPath = envAppData == null ? SVNFileUtil.getSystemApplicationDataPath() : new File(envAppData);
        return ourAppDataPath;
    }

    public static File getSystemApplicationDataPath() {
        if (ourSystemAppDataPath != null) {
            return ourSystemAppDataPath;
        }
        String jnaAppData = SVNJNAUtil.getApplicationDataPath(true);
        if (jnaAppData != null) {
            ourSystemAppDataPath = new File(jnaAppData);
            return ourSystemAppDataPath;
        }
        String envAppData = SVNFileUtil.getEnvironmentVariable("ALLUSERSPROFILE");
        ourSystemAppDataPath = envAppData == null ? new File(new File("C:/Documents and Settings/All Users"), "Application Data") : new File(envAppData, "Application Data");
        return ourSystemAppDataPath;
    }

    public static String getEnvironmentVariable(String name) {
        try {
            Object value;
            Method getenv = System.class.getMethod("getenv", String.class);
            if (getenv != null && (value = getenv.invoke(null, name)) instanceof String) {
                return (String)value;
            }
        }
        catch (Throwable e) {
            try {
                return SVNFileUtil.getEnvironment().getProperty(name);
            }
            catch (Throwable e1) {
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, e);
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, e1);
                return null;
            }
        }
        return null;
    }

    public static void setTestEnvironment(String editor, String mergeTool, String function) {
        ourTestEditor = editor;
        ourTestMergeTool = mergeTool;
        ourTestFunction = function;
    }

    public static String[] getTestEnvironment() {
        return new String[]{ourTestEditor, ourTestMergeTool, ourTestFunction};
    }

    public static Properties getEnvironment() throws Throwable {
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        p = isWindows ? (System.getProperty("os.name").toLowerCase().indexOf("windows 9") >= 0 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec(ENV_COMMAND);
        if (p != null) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                if (idx < 0) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                envVars.setProperty(key, value);
            }
        }
        return envVars;
    }

    public static File createTempDirectory(String name) throws SVNException {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("svnkit" + name, ".tmp");
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary directory: {0}", (Object)e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        tmpFile.mkdirs();
        return tmpFile;
    }

    public static File createTempFile(String prefix, String suffix) throws SVNException {
        File tmpFile = null;
        try {
            if (prefix.length() < 3) {
                prefix = "svn" + prefix;
            }
            tmpFile = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create temporary file: {0}", (Object)e.getMessage());
            SVNErrorManager.error(err, e, Level.FINE, SVNLogType.DEFAULT);
        }
        return tmpFile;
    }

    public static File getSystemConfigurationDirectory() {
        if (isWindows) {
            return new File(SVNFileUtil.getSystemApplicationDataPath(), "Subversion");
        }
        if (isOpenVMS) {
            return new File("/sys$config", "subversion").getAbsoluteFile();
        }
        return new File("/etc/subversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSingleLine(File file) throws IOException {
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("can't open file '" + file.getAbsolutePath() + "'");
        }
        BufferedReader reader = null;
        String line = null;
        FileInputStream is = null;
        try {
            is = SVNFileUtil.createFileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            line = reader.readLine();
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return line;
    }

    private static String decode(CharsetDecoder decoder, byte[] in) {
        ByteBuffer inBuf = ByteBuffer.wrap(in);
        CharBuffer outBuf = CharBuffer.allocate(inBuf.capacity() * Math.round(decoder.maxCharsPerByte() + 0.5f));
        decoder.decode(inBuf, outBuf, true);
        decoder.flush(outBuf);
        decoder.reset();
        return outBuf.flip().toString();
    }

    public static String getCurrentUser() throws SVNException {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourUserID == null && (ourUserID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-u"})) == null) {
            ourUserID = "0";
        }
        return ourUserID;
    }

    public static String getCurrentGroup() throws SVNException {
        if (isWindows || isOpenVMS) {
            return System.getProperty("user.name");
        }
        if (ourGroupID == null && (ourGroupID = SVNFileUtil.execCommand(new String[]{ID_COMMAND, "-g"})) == null) {
            ourGroupID = "0";
        }
        return ourGroupID;
    }

    private static boolean isHex(char ch) {
        return Character.isDigit(ch) || Character.toUpperCase(ch) >= 'A' && Character.toUpperCase(ch) <= 'F';
    }

    public static boolean isAbsolute(File path) {
        return path != null && path.isAbsolute();
    }

    public static String getFilePath(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public static File getFileDir(File file) {
        if (file == null || "".equals(file.getPath())) {
            return null;
        }
        File parentFile = file.getParentFile();
        return parentFile != null ? parentFile : new File("");
    }

    public static File createFilePath(String path) {
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public static File createFilePath(File parent, File child) {
        if (child == null) {
            return parent;
        }
        if (SVNFileUtil.isAbsolute(child)) {
            return child;
        }
        return SVNFileUtil.createFilePath(parent, child.toString());
    }

    public static File createFilePath(File parent, String child) {
        if (child == null) {
            return parent;
        }
        if (parent == null) {
            return SVNFileUtil.createFilePath(child);
        }
        return SVNFileUtil.createFilePath(parent.toString(), child.toString());
    }

    public static File createFilePath(String parent, String child) {
        if (child == null) {
            return null;
        }
        if (parent == null || "".equals(parent)) {
            return SVNFileUtil.createFilePath(child);
        }
        if (SVNPathUtil.isAbsolute(child)) {
            return SVNFileUtil.createFilePath(child);
        }
        return new File(parent, child.toString());
    }

    public static String getFileExtension(File path) {
        if (path == null) {
            return null;
        }
        return SVNFileUtil.getFileNameExtension(path.getName());
    }

    public static String getFileNameExtension(String name) {
        if (name == null) {
            return null;
        }
        int dotInd = name.lastIndexOf(46);
        if (dotInd != -1 && dotInd != 0 && dotInd != name.length() - 1) {
            return name.substring(dotInd + 1);
        }
        return null;
    }

    public static boolean compare(InputStream is, InputStream old) {
        try {
            int r1;
            do {
                int r2;
                if ((r1 = is.read()) == (r2 = old.read())) continue;
                return false;
            } while (r1 >= 0);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static InputStream readSymlink(File link) throws SVNException {
        SVNFileType type;
        if (SVNFileUtil.symlinksSupported() && (type = SVNFileType.getType(link)) == SVNFileType.SYMLINK) {
            StringBuffer sb = new StringBuffer();
            sb.append("link ");
            sb.append(SVNFileUtil.getSymlinkName(link));
            try {
                return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new ByteArrayInputStream(sb.toString().getBytes());
            }
        }
        return SVNFileUtil.openFileForReading(link);
    }

    public static long getFileLength(File file) {
        SVNFileType type;
        if (SVNFileUtil.symlinksSupported() && (type = SVNFileType.getType(file)) == SVNFileType.SYMLINK) {
            try {
                return SVNFileUtil.getSymlinkName(file).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                return SVNFileUtil.getSymlinkName(file).getBytes().length;
            }
        }
        return file.length();
    }

    public static long getFileLastModified(File file) {
        SVNFileType type;
        if (SVNFileUtil.symlinksSupported() && (type = SVNFileType.getType(file)) == SVNFileType.SYMLINK) {
            Long lastModified = SVNJNAUtil.getSymlinkLastModified(file);
            if (lastModified != null) {
                return lastModified;
            }
            try {
                String output = SVNFileUtil.execCommand(new String[]{STAT_COMMAND, "-c", "%Y", file.getAbsolutePath()});
                if (output != null) {
                    try {
                        return Long.parseLong(output) * 1000L;
                    }
                    catch (NumberFormatException e) {}
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.DEFAULT, th);
            }
        }
        return file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean windows;
        DUMMY_OUT = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        DUMMY_IN = new InputStream(){

            public int read() throws IOException {
                return -1;
            }
        };
        ourUseUnsafeCopyOnly = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.no.safe.copy", System.getProperty("javasvn.no.safe.copy", "false")));
        ourCopyOnSetWritable = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.fast.setWritable", "true"));
        ourUseNIOCopying = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.nio.copy", "true"));
        ourIsSleepForTimeStamp = true;
        String logNativeCallsString = System.getProperty("svnkit.log.native.calls", "false");
        logNativeCalls = logNativeCallsString == null ? false : Boolean.parseBoolean(logNativeCallsString);
        String retryCountStr = System.getProperty("svnkit.fs.win32_retry_count", "100");
        int retryCount = -1;
        try {
            retryCount = Integer.parseInt(retryCountStr);
        }
        catch (NumberFormatException nfe) {
            retryCount = -1;
        }
        if (retryCount < 0) {
            retryCount = 100;
        }
        FILE_CREATION_ATTEMPTS_COUNT = retryCount;
        String osName = System.getProperty("os.name");
        String osNameLC = osName == null ? null : osName.toLowerCase();
        boolean bl = windows = osName != null && osNameLC.indexOf("windows") >= 0;
        isOS2 = !windows && osName != null ? (windows = osNameLC.indexOf("os/2") >= 0) : false;
        isWindows = windows;
        isOSX = osName != null && (osNameLC.indexOf("mac") >= 0 || osNameLC.indexOf("darwin") >= 0);
        isLinux = osName != null && (osNameLC.indexOf("linux") >= 0 || osNameLC.indexOf("hp-ux") >= 0);
        isBSD = !isLinux && osName != null && osNameLC.indexOf("bsd") >= 0;
        isSolaris = !isLinux && !isBSD && osName != null && (osNameLC.indexOf("solaris") >= 0 || osNameLC.indexOf("sunos") >= 0);
        boolean bl2 = isOpenVMS = !isOSX && osName != null && osNameLC.indexOf("openvms") >= 0;
        if (!(isWindows || isOSX || isLinux || isBSD || isSolaris || isOpenVMS || isOS2)) {
            isLinux = true;
        }
        is32Bit = "32".equals(System.getProperty("sun.arch.data.model", "32"));
        is64Bit = "64".equals(System.getProperty("sun.arch.data.model", "64"));
        if (isOpenVMS) {
            SVNFileUtil.setAdminDirectoryName("_svn");
        }
        String prefix = "svnkit.program.";
        Properties props = new Properties();
        InputStream is = SVNFileUtil.class.getResourceAsStream("/svnkit.runtime.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
            }
            finally {
                SVNFileUtil.closeFile(is);
            }
        }
        ID_COMMAND = props.getProperty(prefix + "id", "id");
        LN_COMMAND = props.getProperty(prefix + "ln", "ln");
        LS_COMMAND = props.getProperty(prefix + "ls", "ls");
        CHMOD_COMMAND = props.getProperty(prefix + "chmod", "chmod");
        ATTRIB_COMMAND = props.getProperty(prefix + "attrib", "attrib");
        ENV_COMMAND = props.getProperty(prefix + "env", "env");
        STAT_COMMAND = props.getProperty(prefix + "stat", "stat");
        try {
            ourSetWritableMethod = File.class.getMethod("setWritable", Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ourSetExecutableMethod = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        ourTestEditor = null;
        ourTestMergeTool = null;
        ourTestFunction = null;
    }
}

