/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVGetLocksHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLockHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVOptionsHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.helpers.DefaultHandler;

public class DAVConnection {
    protected static final String DAV_CAPABILITY_YES = "yes";
    protected static final String DAV_CAPABILITY_NO = "no";
    protected static final String DAV_CAPABILITY_SERVER_YES = "server-yes";
    private IHTTPConnection myHttpConnection;
    private String myActivityCollectionURL;
    private SVNRepository myRepository;
    private boolean myIsSpoolReport;
    protected boolean myKeepLocks;
    protected Map myLocks;
    protected Map myCapabilities;
    protected IHTTPConnectionFactory myConnectionFactory;
    private HTTPStatus myLastStatus;

    public DAVConnection(IHTTPConnectionFactory connectionFactory, SVNRepository repository) {
        this.myRepository = repository;
        this.myConnectionFactory = connectionFactory;
    }

    public boolean isReportResponseSpooled() {
        return this.myIsSpoolReport;
    }

    public void setReportResponseSpooled(boolean spool) {
        this.myIsSpoolReport = spool;
    }

    public SVNURL getLocation() {
        return this.myRepository.getLocation();
    }

    public HTTPStatus getLastStatus() {
        return this.myLastStatus;
    }

    public void updateLocation() {
        this.myActivityCollectionURL = null;
    }

    public void open(DAVRepository repository) throws SVNException {
        if (this.myHttpConnection == null) {
            this.myHttpConnection = this.myConnectionFactory.createHTTPConnection(repository);
            this.exchangeCapabilities();
        }
    }

    public void fetchRepositoryRoot(DAVRepository repository) throws SVNException {
        if (!repository.hasRepositoryRoot()) {
            String rootPath = repository.getLocation().getURIEncodedPath();
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repository, rootPath, -1L, false, false, null);
            rootPath = rootPath.substring(0, rootPath.length() - info.baselinePath.length());
            SVNURL location = repository.getLocation();
            SVNURL url = location.setPath(rootPath, true);
            repository.setRepositoryRoot(url);
        }
    }

    public void fetchRepositoryUUID(DAVRepository repository) throws SVNException {
        if (!repository.hasRepositoryUUID()) {
            DAVUtil.findStartingProperties(this, repository, repository.getLocation().getURIEncodedPath());
            if (!repository.hasRepositoryUUID()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NO_REPOS_UUID, "Please upgrade to server 0.19 or later");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
    }

    public HTTPStatus doPropfind(String path, HTTPHeader header, StringBuffer body, DefaultHandler handler) throws SVNException {
        this.beforeCall();
        IHTTPConnection httpConnection = this.getConnection();
        return this.performHttpRequest(httpConnection, "PROPFIND", path, header, body, -1, 0, null, handler);
    }

    public SVNLock doGetLock(String path, DAVRepository repos) throws SVNException {
        this.beforeCall();
        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repos, path, -1L, false, true, null);
        StringBuffer body = DAVLockHandler.generateGetLockRequest(null);
        DAVLockHandler handler = new DAVLockHandler();
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Failed to fetch lock information");
        IHTTPConnection httpConnection = this.getConnection();
        HTTPStatus rc = this.performHttpRequest(httpConnection, "PROPFIND", path, null, body, 200, 207, null, handler, context);
        String id = handler.getID();
        if (id == null) {
            return null;
        }
        String comment = handler.getComment();
        String owner = rc.getHeader().getFirstHeaderValue("X-SVN-Lock-Owner");
        String created = rc.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
        SVNDate createdDate = created != null ? SVNDate.parseDate(created) : null;
        path = SVNEncodingUtil.uriDecode(info.baselinePath);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new SVNLock(path, id, owner, comment, createdDate, null);
    }

    public SVNLock[] doGetLocks(String path) throws SVNException {
        DAVGetLocksHandler handler = new DAVGetLocksHandler();
        HTTPStatus status = null;
        try {
            status = this.doReport(path, DAVGetLocksHandler.generateGetLocksRequest(null), handler);
        }
        catch (SVNException e) {
            if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(err, e.getErrorMessage(), SVNLogType.NETWORK);
            } else if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return new SVNLock[0];
            }
            throw e;
        }
        if (status.getCode() == 501) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
            SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
        } else {
            if (status.getCode() == 404) {
                return new SVNLock[0];
            }
            if (status.getError() != null && status.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support locking features");
                SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
        }
        return handler.getLocks();
    }

    public SVNLock doLock(String repositoryPath, String path, DAVRepository repos, String comment, boolean force, long revision) throws SVNException {
        this.beforeCall();
        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this, repos, path, -1L, false, true, null);
        StringBuffer body = DAVLockHandler.generateSetLockRequest(null, comment);
        HTTPHeader header = new HTTPHeader();
        header.setHeaderValue("Depth", "0");
        header.setHeaderValue("Timeout", "Infinite");
        header.setHeaderValue("Content-Type", "text/xml; charset=\"utf-8\"");
        if (revision >= 0L) {
            header.setHeaderValue("X-SVN-Version-Name", Long.toString(revision));
        }
        if (force) {
            header.setHeaderValue("X-SVN-Options", "lock-steal");
        }
        DAVLockHandler handler = new DAVLockHandler();
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Lock request failed");
        SVNException exception = null;
        IHTTPConnection httpConnection = this.getConnection();
        try {
            this.myLastStatus = this.performHttpRequest(httpConnection, "LOCK", path, header, body, -1, 0, null, handler, context);
        }
        catch (SVNException e) {
            this.myLastStatus = httpConnection.getLastStatus();
            exception = e;
        }
        if (this.myLastStatus != null) {
            if (this.myLastStatus.getCode() == 405) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Lock request failed: {0} {1}", this.myLastStatus.getCode(), this.myLastStatus.getReason());
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            if (this.myLastStatus.getError() != null) {
                this.myLastStatus.getError().setChildErrorMessage(null);
                SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
            }
            if (this.myLastStatus.getHeader() == null) {
                if (exception != null) {
                    throw exception;
                }
                return null;
            }
            String userName = this.myLastStatus.getHeader().getFirstHeaderValue("X-SVN-Lock-Owner");
            if (userName == null) {
                userName = httpConnection.getLastValidCredentials() != null ? httpConnection.getLastValidCredentials().getUserName() : null;
            }
            String created = this.myLastStatus.getHeader().getFirstHeaderValue("X-SVN-Creation-Date");
            if (userName == null || created == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Incomplete lock data returned");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            SVNDate createdDate = created != null ? SVNDate.parseDate(created) : null;
            return new SVNLock(repositoryPath, handler.getID(), userName, comment, createdDate, null);
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public void doUnlock(String path, DAVRepository repos, String id, boolean force) throws SVNException {
        this.beforeCall();
        if (id == null) {
            SVNLock lock = this.doGetLock(path, repos);
            if (lock != null) {
                id = lock.getID();
            }
            if (id == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "''{0}'' is not locked in the repository", (Object)path);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
        HTTPHeader header = new HTTPHeader();
        header.setHeaderValue("Lock-Token", "<" + id + ">");
        if (force) {
            header.setHeaderValue("X-SVN-Options", "lock-break");
        }
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unlock request failed");
        IHTTPConnection httpConnection = this.getConnection();
        SVNException exception = null;
        try {
            this.myLastStatus = this.performHttpRequest(httpConnection, "UNLOCK", path, header, null, -1, 0, null, null, context);
        }
        catch (SVNException e) {
            this.myLastStatus = httpConnection.getLastStatus();
            exception = e;
        }
        if (this.myLastStatus != null) {
            switch (this.myLastStatus.getCode()) {
                case 403: {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "Unlock failed on ''{0}'' (403 Forbidden)", (Object)path), SVNLogType.NETWORK);
                    break;
                }
                case 400: {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_LOCK, "No lock on path ''{0}'' (400 Bad Request)", (Object)path), SVNLogType.NETWORK);
                    break;
                }
            }
            if (this.myLastStatus.getCode() >= 300 && this.myLastStatus.getError() != null) {
                SVNErrorMessage error = this.myLastStatus.getError() != null ? this.myLastStatus.getError() : SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED);
                SVNErrorManager.error(error, SVNLogType.NETWORK);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void doGet(String path, OutputStream os) throws SVNException {
        this.beforeCall();
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "GET request failed for ''{0}''", (Object)path);
        IHTTPConnection httpConnection = this.getConnection();
        this.performHttpRequest(httpConnection, "GET", path, null, null, 200, 226, os, null, context);
    }

    public void doGet(String path, String deltaBaseVersionURL, OutputStream os) throws SVNException {
        this.beforeCall();
        HTTPHeader header = null;
        if (deltaBaseVersionURL != null) {
            header = new HTTPHeader();
            header.addHeaderValue("X-SVN-VR-Base", deltaBaseVersionURL);
        }
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "GET request failed for ''{0}''", (Object)path);
        IHTTPConnection httpConnection = this.getConnection();
        this.performHttpRequest(httpConnection, "GET", path, header, null, 200, 226, os, null, context);
    }

    public HTTPStatus doReport(String path, StringBuffer requestBody, DefaultHandler handler) throws SVNException {
        return this.doReport(path, requestBody, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPStatus doReport(String path, StringBuffer requestBody, DefaultHandler handler, boolean spool) throws SVNException {
        this.beforeCall();
        IHTTPConnection httpConnection = this.getConnection();
        httpConnection.setSpoolResponse(spool || this.isReportResponseSpooled());
        try {
            HTTPHeader header = new HTTPHeader();
            header.addHeaderValue("Accept-Encoding", "svndiff1;q=0.9,svndiff;q=0.8");
            HTTPStatus hTTPStatus = this.performHttpRequest(httpConnection, "REPORT", path, header, requestBody, -1, 0, null, handler);
            return hTTPStatus;
        }
        finally {
            httpConnection.setSpoolResponse(false);
        }
    }

    public void doProppatch(String repositoryPath, String path, StringBuffer requestBody, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        this.beforeCall();
        HTTPHeader header = null;
        if (this.myLocks != null && repositoryPath != null && this.myLocks.containsKey(repositoryPath)) {
            header = new HTTPHeader();
            header.setHeaderValue("If", "(<" + this.myLocks.get(repositoryPath) + ">)");
        }
        IHTTPConnection httpConnection = this.getConnection();
        try {
            this.performHttpRequest(httpConnection, "PROPPATCH", path, header, requestBody, 200, 207, null, handler, context);
        }
        catch (SVNException e) {
            SVNErrorMessage err;
            HTTPStatus status = httpConnection.getLastStatus();
            if (status != null) {
                switch (status.getCode()) {
                    case 423: {
                        err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}'';  repository is unchanged", new Object[]{path});
                        SVNErrorManager.error(err, e, SVNLogType.NETWORK);
                        break;
                    }
                }
            }
            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_PROPPATCH_FAILED, "At least one property change failed; repository is unchanged");
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
        }
    }

    public String doMakeActivity(ISVNWorkspaceMediator mediator) throws SVNException {
        String activityURL;
        IHTTPConnection httpConnection;
        HTTPStatus status;
        SVNPropertyValue property;
        this.beforeCall();
        String url = null;
        if (mediator != null && (property = mediator.getWorkspaceProperty("", "svn:wc:ra_dav:activity-url")) != null && property.isString()) {
            url = property.getString();
        }
        String locationPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        if (url == null) {
            url = this.getActivityCollectionURL(locationPath, false);
        }
        if ((status = this.performHttpRequest(httpConnection = this.getConnection(), "MKACTIVITY", activityURL = SVNPathUtil.append(url, DAVConnection.generateUUID()), null, (StringBuffer)null, 201, 404, null, null)).getCode() == 404) {
            url = this.getActivityCollectionURL(locationPath, true);
            activityURL = SVNPathUtil.append(url, DAVConnection.generateUUID());
            status = this.performHttpRequest(httpConnection, "MKACTIVITY", activityURL, null, (StringBuffer)null, 201, 0, null, null);
        }
        if (url != null && mediator != null) {
            mediator.setWorkspaceProperty("", "svn:wc:ra_dav:activity-url", SVNPropertyValue.create(url));
        }
        return activityURL;
    }

    public HTTPStatus doDelete(String path) throws SVNException {
        this.beforeCall();
        IHTTPConnection httpConnection = this.getConnection();
        return this.performHttpRequest(httpConnection, "DELETE", path, null, (StringBuffer)null, 404, 204, null, null);
    }

    public HTTPStatus doDelete(String repositoryPath, String path, long revision) throws SVNException {
        this.beforeCall();
        HTTPHeader header = new HTTPHeader();
        if (revision >= 0L) {
            header.setHeaderValue("X-SVN-Version-Name", Long.toString(revision));
        }
        header.setHeaderValue("Depth", "infinity");
        StringBuffer request = null;
        if (this.myLocks != null) {
            if (this.myLocks.containsKey(repositoryPath)) {
                header.setHeaderValue("If", "<" + repositoryPath + "> (<" + this.myLocks.get(repositoryPath) + ">)");
            }
            if (this.myKeepLocks) {
                header.setHeaderValue("X-SVN-Options", "keep-locks");
            }
            request = new StringBuffer();
            SVNXMLUtil.addXMLHeader(request);
            String locationPath = this.getLocation().getPath();
            locationPath = SVNEncodingUtil.uriEncode(locationPath);
            request = DAVMergeHandler.generateLockDataRequest(request, locationPath, repositoryPath, this.myLocks);
        }
        IHTTPConnection httpConnection = this.getConnection();
        SVNException exception = null;
        try {
            this.myLastStatus = this.performHttpRequest(httpConnection, "DELETE", path, header, request, 204, 0, null, null);
        }
        catch (SVNException e) {
            this.myLastStatus = httpConnection.getLastStatus();
            exception = e;
        }
        if (this.myLastStatus != null && this.myLastStatus.getError() != null) {
            SVNErrorCode errCode = this.myLastStatus.getError().getErrorCode();
            if (errCode == SVNErrorCode.FS_BAD_LOCK_TOKEN || errCode == SVNErrorCode.FS_NO_LOCK_TOKEN || errCode == SVNErrorCode.FS_LOCK_OWNER_MISMATCH || errCode == SVNErrorCode.FS_PATH_ALREADY_LOCKED) {
                String token;
                SVNHashMap childTokens = null;
                if (this.myLocks != null) {
                    childTokens = new SVNHashMap();
                    for (String lockPath : this.myLocks.keySet()) {
                        if (!lockPath.startsWith(path)) continue;
                        childTokens.put(lockPath, this.myLocks.get(lockPath));
                    }
                }
                if (childTokens == null || childTokens.isEmpty()) {
                    SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                } else {
                    this.myLastStatus.setError(null);
                }
                String string = token = this.myLocks != null ? (String)this.myLocks.get(path) : null;
                if (token != null) {
                    childTokens.put(path, token);
                }
                request = new StringBuffer();
                String locationPath = this.getLocation().getPath();
                locationPath = SVNEncodingUtil.uriEncode(locationPath);
                request = DAVMergeHandler.generateLockDataRequest(request, locationPath, repositoryPath, childTokens);
                try {
                    this.myLastStatus = this.performHttpRequest(httpConnection, "DELETE", path, header, request, 204, 404, null, null);
                }
                catch (SVNException e) {
                    this.myLastStatus = httpConnection.getLastStatus();
                    exception = e;
                }
                if (this.myLastStatus.getError() != null) {
                    SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                }
                if (exception != null) {
                    throw exception;
                }
                return this.myLastStatus;
            }
            SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
        }
        if (exception != null) {
            throw exception;
        }
        return this.myLastStatus;
    }

    public HTTPStatus doMakeCollection(String path) throws SVNException {
        this.beforeCall();
        IHTTPConnection httpConnection = this.getConnection();
        return this.performHttpRequest(httpConnection, "MKCOL", path, null, (StringBuffer)null, 201, 0, null, null);
    }

    public HTTPStatus doPutDiff(String repositoryPath, String path, InputStream data, long size, String baseChecksum, String textChecksum) throws SVNException {
        this.beforeCall();
        HTTPHeader headers = new HTTPHeader();
        headers.setHeaderValue("Content-Type", "application/vnd.svn-svndiff");
        headers.setHeaderValue("Content-Length", size + "");
        if (this.myLocks != null && this.myLocks.containsKey(repositoryPath)) {
            headers.setHeaderValue("If", "<" + repositoryPath + "> (<" + this.myLocks.get(repositoryPath) + ">)");
        }
        if (baseChecksum != null) {
            headers.setHeaderValue("X-SVN-Base-Fulltext-MD5", baseChecksum);
        }
        if (textChecksum != null) {
            headers.setHeaderValue("X-SVN-Result-Fulltext-MD5", textChecksum);
        }
        IHTTPConnection httpConnection = this.getConnection();
        return this.performHttpRequest(httpConnection, "PUT", path, headers, data, 201, 204, null, null);
    }

    public HTTPStatus doMerge(String activityURL, boolean response, DefaultHandler handler) throws SVNException {
        this.beforeCall();
        String locationPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        StringBuffer request = DAVMergeHandler.generateMergeRequest(null, locationPath, activityURL, this.myLocks);
        HTTPHeader header = null;
        if (!response || this.myLocks != null && !this.myKeepLocks) {
            header = new HTTPHeader();
            String value = "";
            if (!response) {
                value = value + "no-merge-response";
            }
            if (this.myLocks != null && !this.myKeepLocks) {
                value = value + " release-locks";
            }
            header.setHeaderValue("X-SVN-Options", value);
        }
        IHTTPConnection httpConnection = this.getConnection();
        return this.performHttpRequest(httpConnection, "MERGE", this.getLocation().getURIEncodedPath(), header, request, -1, 0, null, handler);
    }

    public HTTPStatus doCheckout(String activityPath, String repositoryPath, String path, boolean allow404) throws SVNException {
        this.beforeCall();
        StringBuffer request = new StringBuffer();
        LinkedList<String> namespaces = new LinkedList<String>();
        namespaces.add("DAV:");
        SVNXMLUtil.addXMLHeader(request);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "checkout", namespaces, SVNXMLUtil.PREFIX_MAP, request);
        SVNXMLUtil.openXMLTag("D", "activity-set", 1, null, request);
        SVNXMLUtil.openCDataTag("D", "href", activityPath, request);
        SVNXMLUtil.closeXMLTag("D", "activity-set", request);
        SVNXMLUtil.closeXMLTag("D", "checkout", request);
        HTTPHeader header = null;
        if (this.myLocks != null && repositoryPath != null && this.myLocks.containsKey(repositoryPath)) {
            header = new HTTPHeader();
            header.setHeaderValue("If", "(<" + this.myLocks.get(repositoryPath) + ">)");
        }
        IHTTPConnection httpConnection = this.getConnection();
        HTTPStatus status = this.performHttpRequest(httpConnection, "CHECKOUT", path, header, request, 201, allow404 ? 404 : 0, null, null);
        if (allow404 && status.getCode() == 404 && status.getError() != null) {
            status.setError(null);
        }
        if (status.getHeader().hasHeader("Location")) {
            String location = null;
            String locationHeaderValue = status.getHeader().getFirstHeaderValue("Location");
            if (locationHeaderValue.startsWith("/")) {
                location = locationHeaderValue;
            } else {
                SVNURL url = SVNURL.parseURIEncoded(status.getHeader().getFirstHeaderValue("Location"));
                location = url.getURIEncodedPath();
            }
            status.getHeader().setHeaderValue("Location", location);
        }
        return status;
    }

    public void doCopy(String src, String dst, int depth) throws SVNException {
        this.beforeCall();
        HTTPHeader header = new HTTPHeader();
        header.setHeaderValue("Destination", dst);
        header.setHeaderValue("Depth", depth > 0 ? "infinity" : "0");
        SVNErrorMessage context = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "COPY of {0}", (Object)src);
        IHTTPConnection httpConnection = this.getConnection();
        HTTPStatus status = this.performHttpRequest(httpConnection, "COPY", src, header, null, -1, 0, null, null, context);
        if (status.getCode() >= 300 && status.getError() != null) {
            SVNErrorMessage err = status.getError();
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    public void close() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.close();
            this.myHttpConnection = null;
            this.myLocks = null;
            this.myKeepLocks = false;
        }
    }

    public void setLocks(Map locks, boolean keepLocks) {
        this.myLocks = locks;
        this.myKeepLocks = keepLocks;
    }

    public void clearAuthenticationCache() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.clearAuthenticationCache();
        }
    }

    public String getCapabilityResponse(SVNCapability capability) throws SVNException {
        if (this.myCapabilities == null || this.myCapabilities.get(capability) == null) {
            this.exchangeCapabilities();
        }
        return (String)this.myCapabilities.get(capability);
    }

    public void setCapability(SVNCapability capability, String capResult) {
        this.myCapabilities.put(capability, capResult);
    }

    protected IHTTPConnection getConnection() {
        return this.myHttpConnection;
    }

    protected void exchangeCapabilities() throws SVNException {
        String path = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
        IHTTPConnection httpConnection = this.getConnection();
        HTTPStatus status = this.performHttpRequest(httpConnection, "OPTIONS", path, null, (StringBuffer)null, 200, 0, null, null);
        if (status.getCode() == 200) {
            this.parseCapabilities(status);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "OPTIONS request (for capabilities) got HTTP response code {0}", (Object)new Integer(status.getCode()));
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    protected SVNRepository getRepository() {
        return this.myRepository;
    }

    private void parseCapabilities(HTTPStatus status) {
        if (this.myCapabilities == null) {
            this.myCapabilities = new SVNHashMap();
        }
        this.myCapabilities.put(SVNCapability.DEPTH, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.LOG_REVPROPS, DAV_CAPABILITY_NO);
        this.myCapabilities.put(SVNCapability.ATOMIC_REVPROPS, DAV_CAPABILITY_NO);
        List<String> capValues = status.getHeader().getHeaderValues("DAV");
        if (capValues != null) {
            for (String value : capValues) {
                if ("http://subversion.tigris.org/xmlns/dav/svn/depth".equalsIgnoreCase(value)) {
                    this.myCapabilities.put(SVNCapability.DEPTH, DAV_CAPABILITY_YES);
                    continue;
                }
                if ("http://subversion.tigris.org/xmlns/dav/svn/mergeinfo".equalsIgnoreCase(value)) {
                    this.myCapabilities.put(SVNCapability.MERGE_INFO, DAV_CAPABILITY_SERVER_YES);
                    continue;
                }
                if ("http://subversion.tigris.org/xmlns/dav/svn/log-revprops".equalsIgnoreCase(value)) {
                    this.myCapabilities.put(SVNCapability.LOG_REVPROPS, DAV_CAPABILITY_YES);
                    continue;
                }
                if ("http://subversion.tigris.org/xmlns/dav/svn/partial-replay".equalsIgnoreCase(value)) {
                    this.myCapabilities.put(SVNCapability.PARTIAL_REPLAY, DAV_CAPABILITY_YES);
                    continue;
                }
                if (!"http://subversion.tigris.org/xmlns/dav/svn/atomic-revprops".equalsIgnoreCase(value)) continue;
                this.myCapabilities.put(SVNCapability.ATOMIC_REVPROPS, DAV_CAPABILITY_YES);
            }
        }
    }

    private String getActivityCollectionURL(String path, boolean force) throws SVNException {
        if (!force && this.myActivityCollectionURL != null) {
            return this.myActivityCollectionURL;
        }
        DAVOptionsHandler handler = new DAVOptionsHandler();
        IHTTPConnection httpConnection = this.getConnection();
        this.performHttpRequest(httpConnection, "OPTIONS", path, null, DAVOptionsHandler.OPTIONS_REQUEST, -1, 0, null, (DefaultHandler)handler);
        this.myActivityCollectionURL = handler.getActivityCollectionURL();
        if (this.myActivityCollectionURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "The OPTIONS request did not include the requested activity-collection-set; this often means that the URL is not WebDAV-enabled");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return this.myActivityCollectionURL;
    }

    private static String generateUUID() {
        try {
            return SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        }
        catch (SVNException svne) {
            long time = System.currentTimeMillis();
            String uuid = Long.toHexString(time);
            int zeroes = 16 - uuid.length();
            for (int i = 0; i < zeroes; ++i) {
                uuid = "0" + uuid;
            }
            return uuid;
        }
    }

    private void beforeCall() {
        this.myLastStatus = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection httpConnection, String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = httpConnection.request(method, path, header, body, ok1, ok2, dst, handler);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = httpConnection.getLastStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection httpConnection, String method, String src, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = httpConnection.request(method, src, header, body, ok1, ok2, dst, handler, context);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = httpConnection.getLastStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPStatus performHttpRequest(IHTTPConnection httpConnection, String method, String path, HTTPHeader headers, InputStream data, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        this.myLastStatus = null;
        try {
            HTTPStatus hTTPStatus = this.myLastStatus = httpConnection.request(method, path, headers, data, ok1, ok2, dst, handler);
            return hTTPStatus;
        }
        finally {
            this.myLastStatus = httpConnection.getLastStatus();
        }
    }
}

