/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.SubversionManager;
import com.atlassian.jira.plugin.ext.subversion.SvnEntryHandler;
import com.atlassian.jira.plugin.ext.subversion.revisions.DefaultLuceneIndexAccessor;
import com.atlassian.jira.plugin.ext.subversion.revisions.LuceneIndexAccessor;
import com.atlassian.jira.plugin.ext.subversion.revisions.PermittedIssuesRevisionFilter;
import com.atlassian.jira.plugin.ext.subversion.revisions.ProjectRevisionFilter;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.util.Version;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;

public class RevisionIndexer {
    private static final Logger log = LoggerFactory.getLogger(RevisionIndexer.class);
    private static final Long NOT_INDEXED = -1L;
    static final String REVISIONS_INDEX_DIRECTORY = "atlassian-subversion-revisions";
    public static final String FIELD_REVISIONNUMBER = "revision";
    public static final Term START_REVISION = new Term("revision", "");
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_DATE = "date";
    public static final String FIELD_ISSUEKEY = "key";
    public static final String FIELD_PROJECTKEY = "project";
    public static final String FIELD_REPOSITORY = "repository";
    public static final StandardAnalyzer ANALYZER = new StandardAnalyzer(Version.LUCENE_30);
    public static final int MAX_REVISIONS = 100;
    private final MultipleSubversionRepositoryManager multipleSubversionRepositoryManager;
    private final VersionManager versionManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final IndexPathManager indexPathManager;
    private Hashtable<Long, Long> latestIndexedRevisionTbl;
    private LuceneIndexAccessor indexAccessor;

    public RevisionIndexer(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, IndexPathManager indexPathManager) {
        this(multipleSubversionRepositoryManager, versionManager, issueManager, permissionManager, changeHistoryManager, new DefaultLuceneIndexAccessor(), indexPathManager);
    }

    RevisionIndexer(MultipleSubversionRepositoryManager multipleSubversionRepositoryManager, VersionManager versionManager, IssueManager issueManager, PermissionManager permissionManager, ChangeHistoryManager changeHistoryManager, LuceneIndexAccessor accessor, IndexPathManager indexPathManager) {
        this.multipleSubversionRepositoryManager = multipleSubversionRepositoryManager;
        this.versionManager = versionManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.changeHistoryManager = changeHistoryManager;
        this.indexAccessor = accessor;
        this.indexPathManager = indexPathManager;
        this.initializeLatestIndexedRevisionCache();
    }

    public void start() {
        try {
            this.createIndexIfNeeded();
        }
        catch (Exception e) {
            log.error("Error installing the revision index service.", (Throwable)e);
            throw new InfrastructureException("Error installing the revision index service.", (Throwable)e);
        }
    }

    private boolean createIndexIfNeeded() {
        if (log.isDebugEnabled()) {
            log.debug("RevisionIndexer.createIndexIfNeeded()");
        }
        boolean indexExists = this.indexDirectoryExists();
        if (this.getIndexPath() != null && !indexExists) {
            try {
                this.indexAccessor.getIndexWriter(this.getIndexPath(), true, (Analyzer)ANALYZER).close();
                this.initializeLatestIndexedRevisionCache();
                return true;
            }
            catch (IOException ioe) {
                log.error("There's a performing IO on the index.", (Throwable)ioe);
                return false;
            }
        }
        return indexExists;
    }

    private void initializeLatestIndexedRevisionCache() {
        Collection<SubversionManager> repositories = this.multipleSubversionRepositoryManager.getRepositoryList();
        this.latestIndexedRevisionTbl = new Hashtable();
        for (SubversionManager currentRepo : repositories) {
            this.initializeLatestIndexedRevisionCache(currentRepo);
        }
        if (log.isDebugEnabled()) {
            log.debug("Number of repositories: " + repositories.size());
        }
    }

    private void initializeLatestIndexedRevisionCache(SubversionManager subversionManager) {
        this.latestIndexedRevisionTbl.put(subversionManager.getId(), NOT_INDEXED);
    }

    private boolean indexDirectoryExists() {
        try {
            File file = new File(this.getIndexPath());
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getIndexPath() {
        String indexPath = null;
        String rootIndexPath = this.indexPathManager.getPluginIndexRootPath();
        if (rootIndexPath != null) {
            indexPath = rootIndexPath + System.getProperty("file.separator") + REVISIONS_INDEX_DIRECTORY;
        } else {
            log.warn("At the moment the root index path of jira is not set, so we can not form an index path for the subversion plugin.");
        }
        return indexPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex() throws IndexException, IOException {
        if (this.createIndexIfNeeded()) {
            Collection<SubversionManager> repositories = this.multipleSubversionRepositoryManager.getRepositoryList();
            if (log.isDebugEnabled()) {
                log.debug("Number of repositories: " + repositories.size());
            }
            for (SubversionManager subversionManager : repositories) {
                try {
                    long latestIndexedRevision;
                    long repoId;
                    Long tmpLatestIndexedRevision;
                    if (!subversionManager.isActive()) {
                        subversionManager.activate();
                        if (!subversionManager.isActive()) continue;
                    }
                    if ((tmpLatestIndexedRevision = this.getLatestIndexedRevision(repoId = subversionManager.getId())) != null) {
                        latestIndexedRevision = tmpLatestIndexedRevision < 0L ? this.updateLastRevisionIndexed(repoId) : tmpLatestIndexedRevision.longValue();
                    } else {
                        log.warn("Did not update index because null value in hash table for " + repoId);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Updating revision index for repository=" + repoId);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Latest indexed revision for repository=" + repoId + " is : " + latestIndexedRevision);
                    }
                    final IndexWriter writer = this.indexAccessor.getIndexWriter(this.getIndexPath(), false, (Analyzer)ANALYZER);
                    try {
                        final IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
                        try {
                            subversionManager.getLogEntries(latestIndexedRevision, new SvnEntryHandler(){

                                @Override
                                public void handle(SVNLogEntry logEntry) {
                                    if (TextUtils.stringSet((String)logEntry.getMessage()) && RevisionIndexer.this.isKeyInString(logEntry)) {
                                        try {
                                            if (!RevisionIndexer.this.hasDocument(repoId, logEntry.getRevision(), reader)) {
                                                Document doc = RevisionIndexer.this.getDocument(repoId, logEntry);
                                                if (log.isDebugEnabled()) {
                                                    log.debug("Indexing repository=" + repoId + ", revision: " + logEntry.getRevision());
                                                }
                                                writer.addDocument(doc);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                    if (logEntry.getRevision() > latestIndexedRevision) {
                                        RevisionIndexer.this.latestIndexedRevisionTbl.put(repoId, logEntry.getRevision());
                                    }
                                }
                            });
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    log.warn("Unable to index repository '" + subversionManager.getDisplayName() + "'", (Throwable)e);
                }
                catch (RuntimeException e) {
                    log.warn("Unable to index repository '" + subversionManager.getDisplayName() + "'", (Throwable)e);
                }
            }
        }
    }

    protected boolean isKeyInString(SVNLogEntry logEntry) {
        String logMessageUpperCase = StringUtils.upperCase((String)logEntry.getMessage());
        return JiraKeyUtils.isKeyInString((String)logMessageUpperCase);
    }

    protected Long getLatestIndexedRevision(long repoId) {
        return this.latestIndexedRevisionTbl.get(new Long(repoId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDocument(long repoId, long revisionNumber, IndexReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            TermQuery repoQuery = new TermQuery(new Term(FIELD_REPOSITORY, Long.toString(repoId)));
            TermQuery revQuery = new TermQuery(new Term(FIELD_REVISIONNUMBER, Long.toString(revisionNumber)));
            BooleanQuery repoAndRevQuery = new BooleanQuery();
            repoAndRevQuery.add((Query)repoQuery, BooleanClause.Occur.MUST);
            repoAndRevQuery.add((Query)revQuery, BooleanClause.Occur.MUST);
            TopDocs hits = searcher.search((Query)repoAndRevQuery, 100);
            if (hits.totalHits == 1) {
                boolean bl = true;
                return bl;
            }
            if (hits.totalHits == 0) {
                boolean bl = false;
                return bl;
            }
            log.error("Found MORE than one document for revision: " + revisionNumber + ", repository=" + repoId);
            boolean bl = true;
            return bl;
        }
        finally {
            searcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateLastRevisionIndexed(long repoId) throws IndexException, IOException {
        IndexReader reader;
        if (log.isDebugEnabled()) {
            log.debug("Updating last revision indexed.");
        }
        long latestIndexedRevision = this.latestIndexedRevisionTbl.get(repoId);
        String indexPath = this.getIndexPath();
        try {
            reader = IndexReader.open((Directory)FSDirectory.open((File)new File(indexPath), (LockFactory)new SimpleFSLockFactory()));
        }
        catch (IOException e) {
            log.error("Problem with path " + indexPath + ": " + e.getMessage(), (Throwable)e);
            throw new IndexException("Problem with path " + indexPath + ": " + e.getMessage(), (Exception)e);
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Document doc;
            long revision;
            TopFieldDocs hits = searcher.search((Query)new TermQuery(new Term(FIELD_REPOSITORY, Long.toString(repoId))), 100, new Sort(new SortField(FIELD_REVISIONNUMBER, 6, true)));
            if (hits.totalHits > 0 && (revision = Long.parseLong((doc = searcher.doc(hits.scoreDocs[0].doc)).get(FIELD_REVISIONNUMBER))) > latestIndexedRevision) {
                latestIndexedRevision = revision;
            }
            log.debug("latestIndRev for " + repoId + " = " + latestIndexedRevision);
            this.latestIndexedRevisionTbl.put(repoId, latestIndexedRevision);
        }
        finally {
            reader.close();
        }
        return latestIndexedRevision;
    }

    protected Document getDocument(long repoId, SVNLogEntry logEntry) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(FIELD_MESSAGE, logEntry.getMessage(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (logEntry.getAuthor() != null) {
            doc.add((Fieldable)new Field(FIELD_AUTHOR, logEntry.getAuthor(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        doc.add((Fieldable)new Field(FIELD_REPOSITORY, Long.toString(repoId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(FIELD_REVISIONNUMBER, Long.toString(logEntry.getRevision()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (logEntry.getDate() != null) {
            doc.add((Fieldable)new Field(FIELD_DATE, DateField.dateToString((Date)logEntry.getDate()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        List<String> keys = this.getIssueKeysFromString(logEntry);
        HashMap<String, String> projects = new HashMap<String, String>();
        for (String issueKey : keys) {
            doc.add((Fieldable)new Field(FIELD_ISSUEKEY, issueKey, Field.Store.YES, Field.Index.NOT_ANALYZED));
            String projectKey = this.getProjectKeyFromIssueKey(issueKey);
            if (projects.containsKey(projectKey)) continue;
            projects.put(projectKey, projectKey);
            doc.add((Fieldable)new Field(FIELD_PROJECTKEY, projectKey, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return doc;
    }

    protected String getProjectKeyFromIssueKey(String issueKey) {
        String issueKeyUpperCase = StringUtils.upperCase((String)issueKey);
        return JiraKeyUtils.getFastProjectKeyFromIssueKey((String)issueKeyUpperCase);
    }

    protected List<String> getIssueKeysFromString(SVNLogEntry logEntry) {
        String logMessageUpperCase = StringUtils.upperCase((String)logEntry.getMessage());
        return JiraKeyUtils.getIssueKeysFromString((String)logMessageUpperCase);
    }

    public Map<Long, List<SVNLogEntry>> getLogEntriesByRepository(Issue issue) throws IndexException, IOException {
        return this.getLogEntriesByRepository(issue, 0, 100, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByRepository(Issue issue, int startIndex, int pageSize, boolean ascending) throws IndexException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving revisions for : " + issue.getKey());
        }
        if (!this.indexDirectoryExists()) {
            log.warn("The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            TopFieldDocs hits = searcher.search(this.createQueryByIssueKey(issue), 100, new Sort(new SortField(FIELD_DATE, 3, !ascending)));
            LinkedHashMap<Long, List<SVNLogEntry>> logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>(hits.totalHits);
            int endIndex = startIndex + pageSize;
            for (int i = 0; i < Math.min(hits.totalHits, 100); ++i) {
                long revision;
                if (i < startIndex || i >= endIndex) continue;
                Document doc = searcher.doc(hits.scoreDocs[i].doc);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error("Could not find log message for revision: " + Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                    continue;
                }
                ArrayList<SVNLogEntry> entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId);
                if (entries == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
            LinkedHashMap<Long, List<SVNLogEntry>> linkedHashMap = logEntries;
            return linkedHashMap;
        }
        finally {
            searcher.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByProject(String projectKey, User user, int startIndex, int pageSize) throws IndexException, IOException {
        LinkedHashMap<Long, List<SVNLogEntry>> logEntries;
        if (!this.indexDirectoryExists()) {
            log.warn("getLogEntriesByProject() The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        TermQuery query = new TermQuery(new Term(FIELD_PROJECTKEY, projectKey));
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            TopFieldDocs hits = searcher.search((Query)query, (Filter)new ProjectRevisionFilter(this.issueManager, this.permissionManager, user, projectKey), 100, new Sort(new SortField(FIELD_DATE, 6, true)));
            if (hits == null) {
                log.info("getLogEntriesByProject() No matches -- returning null.");
                Map<Long, List<SVNLogEntry>> map = null;
                return map;
            }
            logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>();
            int endIndex = startIndex + pageSize;
            int j = Math.min(hits.totalHits, 100);
            for (int i = 0; i < j; ++i) {
                long revision;
                if (i < startIndex || i >= endIndex) continue;
                Document doc = searcher.doc(hits.scoreDocs[i].doc);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error("getLogEntriesByProject() Could not find log message for revision: " + revision);
                    continue;
                }
                ArrayList<SVNLogEntry> entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId);
                if (entries == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
        }
        finally {
            searcher.close();
            reader.close();
        }
        return logEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<SVNLogEntry>> getLogEntriesByVersion(com.atlassian.jira.project.version.Version version, User user, int startIndex, int pageSize) throws IndexException, IOException {
        LinkedHashMap<Long, List<SVNLogEntry>> logEntries;
        TermQuery termQuery;
        if (!this.indexDirectoryExists()) {
            log.warn("getLogEntriesByVersion() The indexes for the subversion plugin have not yet been created.");
            return null;
        }
        HashSet issues = new HashSet();
        issues.addAll(this.versionManager.getFixIssues(version));
        issues.addAll(this.versionManager.getAffectsIssues(version));
        int maxClauses = BooleanQuery.getMaxClauseCount();
        if (issues.size() > maxClauses) {
            BooleanQuery.setMaxClauseCount((int)issues.size());
        }
        BooleanQuery query = new BooleanQuery();
        HashSet<String> permittedIssueKeys = new HashSet<String>();
        for (GenericValue issue : issues) {
            String key = issue.getString(FIELD_ISSUEKEY);
            MutableIssue theIssue = this.issueManager.getIssueObject(key);
            if (!this.permissionManager.hasPermission(29, (Issue)theIssue, user)) continue;
            termQuery = new TermQuery(new Term(FIELD_ISSUEKEY, key));
            query.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            permittedIssueKeys.add(key);
        }
        IndexReader reader = this.indexAccessor.getIndexReader(this.getIndexPath());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            TopFieldDocs hits = searcher.search((Query)query, (Filter)new PermittedIssuesRevisionFilter(this.issueManager, this.permissionManager, user, permittedIssueKeys), 100, new Sort(new SortField(FIELD_DATE, 6, true)));
            if (hits == null) {
                log.info("getLogEntriesByVersion() No matches -- returning null.");
                termQuery = null;
                return termQuery;
            }
            logEntries = new LinkedHashMap<Long, List<SVNLogEntry>>();
            int endDocIndex = startIndex + pageSize;
            int j = Math.min(hits.totalHits, 100);
            for (int i = 0; i < j; ++i) {
                ArrayList<SVNLogEntry> entries;
                long revision;
                if (i < startIndex || i >= endDocIndex) continue;
                Document doc = searcher.doc(hits.scoreDocs[i].doc);
                long repositoryId = Long.parseLong(doc.get(FIELD_REPOSITORY));
                SubversionManager manager = this.multipleSubversionRepositoryManager.getRepository(repositoryId);
                SVNLogEntry logEntry = manager.getLogEntry(revision = Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                if (logEntry == null) {
                    log.error("getLogEntriesByVersion() Could not find log message for revision: " + Long.parseLong(doc.get(FIELD_REVISIONNUMBER)));
                }
                if ((entries = (ArrayList<SVNLogEntry>)logEntries.get(repositoryId)) == null) {
                    entries = new ArrayList<SVNLogEntry>();
                    logEntries.put(repositoryId, entries);
                }
                entries.add(logEntry);
            }
        }
        finally {
            searcher.close();
            reader.close();
            BooleanQuery.setMaxClauseCount((int)maxClauses);
        }
        return logEntries;
    }

    public void addRepository(SubversionManager subversionInstance) {
        this.initializeLatestIndexedRevisionCache(subversionInstance);
        try {
            this.updateIndex();
        }
        catch (Exception e) {
            throw new InfrastructureException("Could not index repository", (Throwable)e);
        }
    }

    public void removeEntries(SubversionManager subversionInstance) throws IOException, IndexException, SVNException {
        if (log.isDebugEnabled()) {
            log.debug("Deleteing revisions for : " + subversionInstance.getRoot());
        }
        if (!this.indexDirectoryExists()) {
            log.warn("The indexes for the subversion plugin have not yet been created.");
        } else {
            long repoId = subversionInstance.getId();
            IndexWriter writer = null;
            try {
                writer = this.indexAccessor.getIndexWriter(this.getIndexPath(), false, (Analyzer)ANALYZER);
                writer.deleteDocuments(new Term(FIELD_REPOSITORY, Long.toString(repoId)));
                this.initializeLatestIndexedRevisionCache(subversionInstance);
            }
            catch (IOException ie) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to open index. Perhaps the index is corrupted. It might be possible to fix the problem by removing the index directory (" + this.getIndexPath() + ")", (Throwable)ie);
                }
                throw ie;
            }
            finally {
                block15: {
                    if (null != writer) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioe) {
                            if (!log.isWarnEnabled()) break block15;
                            log.warn("Unable to close index.", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    protected Query createQueryByIssueKey(Issue issue) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(FIELD_ISSUEKEY, issue.getKey())), BooleanClause.Occur.SHOULD);
        Collection previousIssueKeys = this.changeHistoryManager.getPreviousIssueKeys(issue.getId());
        for (String previousIssueKey : previousIssueKeys) {
            TermQuery termQuery = new TermQuery(new Term(FIELD_ISSUEKEY, previousIssueKey));
            query.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }
}

