/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.ext.subversion.revisions.AbstractRevisionFilter;
import com.atlassian.jira.security.PermissionManager;
import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.util.DocIdBitSet;

public class PermittedIssuesRevisionFilter
extends AbstractRevisionFilter {
    private final Set<String> permittedIssueKeys;

    public PermittedIssuesRevisionFilter(IssueManager issueManager, PermissionManager permissionManager, User user, Set<String> permittedIssueKeys) {
        super(issueManager, permissionManager, user);
        this.permittedIssueKeys = permittedIssueKeys;
    }

    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        BitSet bitSet = new BitSet(indexReader.maxDoc());
        for (String issueKey : this.permittedIssueKeys) {
            TermDocs termDocs = indexReader.termDocs(new Term("key", issueKey));
            while (termDocs.next()) {
                bitSet.set(termDocs.doc(), true);
            }
        }
        return new DocIdBitSet(bitSet);
    }
}

