/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.action;

import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.WebLinkType;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class SubversionActionSupport
extends JiraWebActionSupport {
    private MultipleSubversionRepositoryManager multipleRepoManager;
    private List webLinkTypes;

    public SubversionActionSupport(MultipleSubversionRepositoryManager manager) {
        this.multipleRepoManager = manager;
    }

    protected MultipleSubversionRepositoryManager getMultipleRepoManager() {
        return this.multipleRepoManager;
    }

    public boolean hasPermissions() {
        return this.isHasPermission(0);
    }

    public String doDefault() {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        return "input";
    }

    public List getWebLinkTypes() throws IOException {
        if (this.webLinkTypes == null) {
            this.webLinkTypes = new ArrayList();
            Properties properties = new Properties();
            properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/weblinktypes.properties"));
            String[] types = properties.getProperty("types", "").split(" ");
            for (int i = 0; i < types.length; ++i) {
                this.webLinkTypes.add(new WebLinkType(types[i], properties.getProperty(types[i] + ".name", types[i]), properties.getProperty(types[i] + ".view"), properties.getProperty(types[i] + ".changeset"), properties.getProperty(types[i] + ".file.added"), properties.getProperty(types[i] + ".file.modified"), properties.getProperty(types[i] + ".file.replaced"), properties.getProperty(types[i] + ".file.deleted")));
            }
        }
        return this.webLinkTypes;
    }

    @HtmlSafe
    public String escapeJavaScript(String javascriptUnsafeString) {
        return StringEscapeUtils.escapeJavaScript((String)javascriptUnsafeString);
    }
}

