/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.subversion.revisions.scheduling;

import com.atlassian.jira.plugin.ext.subversion.MultipleSubversionRepositoryManager;
import com.atlassian.jira.plugin.ext.subversion.revisions.RevisionIndexer;
import com.atlassian.jira.plugin.ext.subversion.revisions.scheduling.UpdateIndexMonitorImpl;
import com.atlassian.sal.api.scheduling.PluginJob;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIndexTask
implements PluginJob {
    private static final Logger logger = LoggerFactory.getLogger(UpdateIndexTask.class);

    public void execute(Map<String, Object> jobDataMap) {
        UpdateIndexMonitorImpl monitor = (UpdateIndexMonitorImpl)jobDataMap.get("UpdateIndexMonitorImpl:instance");
        MultipleSubversionRepositoryManager multipleSubversionRepositoryManager = (MultipleSubversionRepositoryManager)jobDataMap.get("MultipleSubversionRepositoryManager");
        assert (monitor != null);
        try {
            if (null == multipleSubversionRepositoryManager) {
                return;
            }
            RevisionIndexer revisionIndexer = multipleSubversionRepositoryManager.getRevisionIndexer();
            if (revisionIndexer != null) {
                revisionIndexer.updateIndex();
            } else {
                logger.warn("Tried to index changes but SubversionManager has no revision indexer?");
            }
        }
        catch (Exception e) {
            logger.error("Error indexing changes: " + e);
        }
    }
}

