define('feature/filters/filter-item-view', ['backbone', 'util/router'], function (Backbone, router) {
    var FilterItemView = Backbone.View.extend({
        tagName: 'li',
        className: 'filter-entry',

        events: {
            'click': 'gotoFilter'
        },

        render: function () {
            this.$el.html(AtlassianMobile.Templates.JIRA.FilterList.listEntry({
                filter: this.model.toJSON()
            }));
        },

        gotoFilter: function () {
            router.navigate('filter/' + this.model.get('id'), {trigger: true});
        }
    });

    return FilterItemView;
});