define('util/hide-address-bar', ['zepto', 'util/scroll-tops'], function ($, Scrolling) {

    var isMobileSafari = /iPhone|iPad/.test(navigator.userAgent);

    var viewportHeight = window.innerHeight;

    var hideAddressBar = function () {
        if (Scrolling.hasSavedPosition()) {
            return;
        }

        // Sometimes we don't need to wait!
        window.scroll(0, 1);

        var $outerContainer = $("#outer-container");

        var documentHeight = document.height,
            tooShort = documentHeight <= viewportHeight;

        if (tooShort) {
            // +60 to account for address bar hiding in iOS
            // +1 to account for window.scroll(0, 1)
            var newHeight = viewportHeight + (isMobileSafari ? 61 : 1);
            $outerContainer.css("min-height", newHeight);
        }

        setTimeout(function () {
            window.scroll(0, 1);
        }, 50);

    };

    $(window)
        .bind("load", function () {
            if (!window.pageYOffset) {
                hideAddressBar();
            }
        })
        .bind("orientationchange", function() {
            viewportHeight = window.innerHeight;
            hideAddressBar();
        });

    return hideAddressBar;
});