define('layout/loading-overlay/loading-overlay-view',
    [
        './loading-overlay.less',
        './loading-overlay.soy',
        'zepto',
        'underscore',
        'backbone',
        'util/presenter',
        'require'
    ], function (css, Templates, $, _, Backbone, Presenter, require) {
        require('widget/jquery-spinner/jquery-spinner');

    return Backbone.View.extend({

        loading: null,
        positionListener: null,

        className: 'loading-overlay',

        events: {
            'click .loading-cancel': 'cancelLoading'
        },

        render: function() {
            this.$el.html(Templates.pageLoading());
            $('#outer-container').append(this.$el);
        },

        showLoading: function() {
            const $indicator = $('.page-loading-indicator');
            const $overlay = $('.loading-overlay').addClass('show');
            $overlay.css('height', $('#inner-container').height());
            const $spinner = $indicator.find('.spinner').spin('small', {
                left: 0,
                top: 'auto'
            });
            const $cancel = $indicator.find('.loading-cancel').show();
            const $success = $indicator.find('.loading-success');
            this.loading = {
                overlay: $overlay,
                indicator: $indicator,
                cancel: $cancel,
                spinner: $spinner
            };
            this.success = $success;

            this.positionPageSpinner();
            _.defer(function () {
                $indicator.addClass('show');
            });
            this.positionListener =  _.bind(this.positionPageSpinner, this);
            $(window).on('resize scroll', this.positionListener);
        },

        /**
         * Remove any active loading spinners
         */
        hideLoading: function () {
            if (this.loading) {
                this.loading.spinner.spinStop();
                this.loading.cancel.hide();
                if (this.loading.overlay) {
                    this.loading.overlay.removeClass('show');
                }
                if (this.positionListener) {
                    $(window).off('resize scroll', this.positionListener);
                    this.loading.indicator.removeClass('show');
                }
                this.loading = null;
            }
        },

        /**
         * Make sure a full-page spinner is positioned in the centre of the screen
         */
        positionPageSpinner: function () {
            if (this.loading && this.loading.overlay) {
                const $elem = this.loading.indicator;
                const ew = $elem.width();
                const eh = $elem.height();
                const ww = window.innerWidth;
                const wh = window.innerHeight;
                $elem.css({
                    left: ww / 2 - ew / 2,
                    top: (wh / 2 - eh / 2) + window.scrollY
                });
            }
        },

        /**
         * Cancel any AJAX requests that are currently active for the active PageView
         */
        cancelLoading: function () {
            Presenter.cancelLoading();
        },
    });

});
