define('feature/issues/fields/description-view', ['../issue.soy', 'zepto', 'backbone', 'util/misc'], function (Templates, $, Backbone, utils) {
    return Backbone.View.extend({
        className: 'description-container no-flicker',

        events: {
            'click .description-toggle': 'toggleDescription'
        },

        _updateData: function () {
            //CAS-433: Description field does not always need to be visible on an issue. If its not there assume
            //its the empty string which is as good as.
            this.descriptionData = this.model.get('renderedFields').description || "";
            this.strippedDescription = utils.stripHTML(this.descriptionData);
            if (!this.model.descriptionState) {
                this.model.descriptionState = {
                    expand: this.model.get('renderedFields').comment.total == 0
                }
            }
        },

        initialize: function () {
            this._updateData();
            this.listenTo(this.model, 'change:renderedFields', function () {
                this._updateData();
                this.render();
            });
        },

        render: function () {
            if (this.descriptionData.trim().length > 0) {
                if (this.model.descriptionState.expand) {
                    this.$el.html(Templates.drawDescription({
                        description: this.descriptionData
                    }));
                } else {
                    this.$el.html(Templates.drawDescriptionPreview({
                        cleanDescription: this.strippedDescription
                    }));
                }
            }
            return this;
        },

        toggleDescription: function(e) {
            const $target = $(e.target);
            // If the user clicked on a link, don't collapse
            if (!$target.closest('a, .description-toggle').hasClass('description-toggle') || $target.closest('img').length ) {
                return;
            }

            this.model.descriptionState.expand = !this.model.descriptionState.expand;
            this.render();
        }
    });
});
