define('feature/issue-lists/issue-list-collection',
    ['backbone', 'feature/issues/issue-model', 'util/app-data', 'util/ajax'],
    function (Backbone, IssueModel, appData, ajaxUtil) {

        const IssueList = Backbone.Collection.extend({
            model: IssueModel,
            startAt: 20,
            numOfResults: 20,
            listTotalLength: 0, //THIS BELONGS IN COMMON LIST COLLECTION TOO

            ajaxOptions: function () {
                return {anonAllowed: this.options.anonAllowed};
            },

            initialize: function (models, options) {
                this.options = options;
            },

            _generateUrl: function (startAt, maxResults) {
                const fields = 'summary,issuetype,comment,parent,status';
                const url = [
                    '/rest/api/latest/search?jql=' + encodeURIComponent(this.options.jql),
                    'fields=' + encodeURIComponent(fields),
                    'startAt=' + encodeURIComponent(startAt),
                    'maxResults=' + encodeURIComponent(maxResults)
                ].join('&');
                return url;
            },

            url: function () {
                return this._generateUrl(0, this.numOfResults);
            },

            parse: function(response) {
                this.listTotalLength = response.total; //update the issue list size
                return response && response.issues;
            },

            // TODO: Consider adding this to Collection Class (List?) and have IssueList extend that
            getMore: function(numOfIssues) {
                const collection = this;
                this.numOfResults += numOfIssues;
                ajaxUtil.rest({
                    url: this._generateUrl(this.startAt, numOfIssues),
                    success: function(data){
                        collection.add(data.issues);
                        collection.trigger("showMoreComplete");
                    }
                })
                this.startAt += numOfIssues;
            }
        });

        return IssueList;
    }
);
