define('feature/filters/filter-list-view',
    [
        './filter-list.css',
        './filter-list.soy',
        '../../layout/base/base.soy',
        'layout/base/page-view',
        'layout/header/header-view',
        'layout/loading-overlay/loading-overlay-view',
        'feature/filters/filter-item-view',
        'util/app-data',
        'underscore'
    ],
    function (css, Templates, BaseTemplates, PageView, HeaderView, LoadingOverlayView, FilterItemView, appData, _) {

        const FilterListView = PageView.extend({
            className: 'card filter-list-card',

            desktopUrl: appData.get('context-path') + '/secure/ManageFilters.jspa?filterView=favourites',

            pageTitle: function () {
                return '[' + this.title + ']';
            },

            initialize: function (options) {
                this.title = options.title;
                this.childViews = [];
                this.listenTo(this.collection, 'reset', this.render);

                // Initialise the header
                const headerAttributes = {
                    el: this.$el,
                    title: this.title,
                    action: false
                };
                this.header = new HeaderView(headerAttributes);
                this.loadingOverlay = new LoadingOverlayView();
            },

            render: function () {
                this.$el.empty();
                this.header.render();
                this.loadingOverlay.render();

                // Render content
                this.$el.append(Templates.listContainer({
                    title: this.title,
                    filters: this.collection.toJSON()
                }));

                const $list = this.$('.filter-list');
                var filters = this.collection;
                const childViews = [];

                if (!filters.isEmpty()) {
                    filters.each(function (filter) {
                        const view = new FilterItemView({model: filter});
                        childViews.push(view);
                        view.render();
                        $list.append(view.$el);
                    });
                }
                this.childViews.concat(childViews);

                this.$el.append(BaseTemplates.atlasFooter());
            },

            onClose: function(){
                _.each(this.childViews, function (view){
                    view.close();
                });
            }
        });

        return FilterListView;
    }
);
