/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.config;

import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DefaultJiraFilters {
    public static final long MY_OPEN_ISSUES_ID = -1L;
    public static final long REPORTED_BY_ME_ID = -2L;
    public static final long VIEWED_RECENTLY_ID = -3L;
    public static final long ALL_ISSUES_ID = -4L;
    public static final long OPEN_ISSUES_ID = -5L;
    public static final long DONE_ISSUES_ID = -9L;
    public static final long CREATED_RECENTLY_ID = -6L;
    public static final long RESOLVED_RECENTLY_ID = -7L;
    public static final long UPDATED_RECENTLY_ID = -8L;
    private static final List<Long> PUBLICLY_AVAILABLE_FILTERS = ImmutableList.of((Object)-3L, (Object)-4L, (Object)-5L, (Object)-9L, (Object)-6L, (Object)-7L, (Object)-8L);
    private final Map<Long, Query> queries = ImmutableMap.builder().put((Object)-1L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("assignee").eqFunc("currentUser").and().addCondition("resolution").eq("Unresolved").endWhere().orderBy().add("updated", SortOrder.DESC).buildQuery()).put((Object)-2L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("reporter").eqFunc("currentUser").endWhere().orderBy().add("created", SortOrder.DESC).buildQuery()).put((Object)-3L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("issuekey").inFunc("issueHistory").endWhere().orderBy().add("lastViewed", SortOrder.DESC).buildQuery()).put((Object)-4L, (Object)JqlQueryBuilder.newBuilder().orderBy().add("created", SortOrder.DESC).buildQuery()).put((Object)-5L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("resolution").eq("Unresolved").endWhere().orderBy().add("priority", SortOrder.DESC).add("updated", SortOrder.DESC).buildQuery()).put((Object)-9L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("statusCategory").eq("Done").endWhere().orderBy().add("updated", SortOrder.DESC).buildQuery()).put((Object)-6L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("created").gtEq("-1w").endWhere().orderBy().add("created", SortOrder.DESC).buildQuery()).put((Object)-7L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("resolutiondate").gtEq("-1w").endWhere().orderBy().add("updated", SortOrder.DESC).buildQuery()).put((Object)-8L, (Object)JqlQueryBuilder.newBuilder().where().addCondition("updated").gtEq("-1w").endWhere().orderBy().add("updated", SortOrder.DESC).buildQuery()).build();
    private final Map<Long, String> titles = ImmutableMap.builder().put((Object)-1L, (Object)"My open Issues").put((Object)-2L, (Object)"Reported by me").put((Object)-3L, (Object)"Viewed recently").put((Object)-4L, (Object)"All issues").put((Object)-5L, (Object)"Open issues").put((Object)-9L, (Object)"Done issues").put((Object)-6L, (Object)"Created recently").put((Object)-7L, (Object)"Resolved recently").put((Object)-8L, (Object)"Updated recently").build();

    public Query getQueryById(long filterId) {
        Query query = this.queries.get(filterId);
        if (query == null) {
            throw new IllegalArgumentException(String.format("Filter cannot be found by id: %s", filterId));
        }
        return query;
    }

    public String getTitleById(long filterId) {
        String title = this.titles.get(filterId);
        if (title == null) {
            throw new IllegalArgumentException(String.format("Title cannot be found by id: %s", filterId));
        }
        return title;
    }

    public boolean isFilterPubliclyAvailable(long filterId) {
        return PUBLICLY_AVAILABLE_FILTERS.contains(filterId);
    }
}

