/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.auth;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.security.Principal;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationUserProvider {
    private final UserManager userManager;

    @Autowired
    public ApplicationUserProvider(@ComponentImport UserManager userManager) {
        this.userManager = userManager;
    }

    @Nullable
    public ApplicationUser getRemoteUser(HttpServletRequest request) {
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        Authenticator authenticator = securityConfig.getAuthenticator();
        Principal p = authenticator.getUser(request);
        if (p == null) {
            return null;
        }
        if (p instanceof ApplicationUser) {
            return (ApplicationUser)p;
        }
        return this.getRemoteUser(p.getName());
    }

    @Nullable
    private ApplicationUser getRemoteUser(String username) {
        return this.userManager.getUserByKey(username);
    }
}

