define('util/misc', ['util/app-data', 'exports'], function (appData, exports) {

    exports.stripHTML = function(string) {
        /* This bit of regex was copied from JIRA's JiraVelocityHelper */
        var stripped = string.replace(/<[^>]*>/g, "");
        /* We want to strip whatever the text is to something manageable.
        Things get slow when we try to put in 10k characters and then try to hide them all.
        1000 was selected so that wider devices can still see a decent preview */
        if (stripped.length > 1000) {
            stripped = stripped.substring(0, 1000);
        }
        return stripped;
    };

    exports.forceRepaint = function () {

        var $div = $("<div />");

        var $container = $("#inner-container");
        $container.append($div);

        var windowHeight = $(window).height();
        $container.css({height: windowHeight});

        setTimeout(function () {
            $container.css({height: "auto"});
            $div.remove();
        }, 0);
    };

});