define('util/auth',
    ['backbone', 'util/ajax', 'util/app-data', 'util/events', 'util/router', 'util/scroll-tops'], // 'layout/login/login-view'
    function (Backbone, ajax, appData, events, router, Scrolling) {
        var auth = {
            getLoginDestination: function () {
                var location = window.location;
                var contextPath = appData.get('context-path');
                var currentPath = location.href.substr((location.origin + contextPath).length).replace('#login/', '#');
                var url = contextPath + '/login.jsp?os_destination=' + encodeURIComponent(currentPath);
                return url;
            },

            getLogoutDestination: function () {
                var contextPath = appData.get('context-path');
                var url = contextPath + '/logout';
                return url;
            },

            showLoginPage: function (replace) {
                if (appData.getBoolean('is-ondemand') || appData.getBoolean('is-lasso')) {
                    var url = auth.getLoginDestination();
                    window.location = url;
                } else {
                    var fragment = Backbone.history.fragment;
                    if (fragment.substr(0, 6) != 'login/') {
                        // replace is true by default unless otherwise specified
                        var replaceVal = typeof replace === "undefined" ? true : !!replace;
                        router.navigate('login/' + fragment, {
                            trigger: true,
                            replace: replaceVal
                        });
                    }
                }
            },

            showCleanLoginPage: function () {
                if (appData.getBoolean('is-ondemand') || appData.getBoolean('is-lasso')) {
                    var contextPath = appData.get('context-path');
                    var url = contextPath + '/login.jsp';
                    window.location = url;
                } else {
                    router.navigate('login', {
                        trigger: true,
                        replace: false
                    });
                }
            },

            login: function (user) {
                this._updateUser(user);
                events.user.trigger('auth.login');
            },

            logout: function (options) {
                if (appData.getBoolean('is-lasso')) {
                    var url = auth.getLogoutDestination();
                    window.location = url;
                } else {
                    this.triggerLogout();
                    options = options || {};
                    var willRedirect = options.showLoginPage !== false && appData.getBoolean('is-ondemand');
                    // We don't use a callback here because if the call fails with 401,
                    // the auth handler in util/ajax will show the login page anyway.
                    ajax.rest({
                        url: '/rest/auth/latest/session',
                        type: 'DELETE',
                        // Need to block the OnDemand login page redirect to wait until the session has been destroyed
                        async: !willRedirect
                    });
                    if (options.showLoginPage !== false) {
                        auth.showCleanLoginPage();
                    }
                }
            },

            /**
             * Clear the stored username and trigger the logout event.
             * Used for updating the UI when detecting a session timeout, but without showing the login page.
             */
            triggerLogout: function () {
                this._clearUser();
                Scrolling.resetAll();
                events.user.trigger('auth.logout');
            },

            _updateUser: function (user) {
                appData.put('remote-user', user.name);
                appData.put('user-data', user);
            },

            _clearUser: function () {
                appData.put('remote-user', '');
                appData.put('user-data', null);
            },

            on: function (event, handler) {
                events.user.on('auth.' + event, handler);
            },

            off: function (event, handler) {
                events.user.off('auth.' + event, handler);
            }
        };

        return auth;
    }
);