define('layout/error/error-view', ['layout/base/page-view', 'layout/header/header-view'], function (PageView, HeaderView) {

    var statusText = {
        0: {
            title: AJS.I18n.getText('jira.mobile.error.network.failure.title'),
            desc: AJS.I18n.getText('jira.mobile.error.network.failure.desc')
        },
        403: {
            title: AJS.I18n.getText('jira.mobile.error.permission.violation.title'),
            desc: AJS.I18n.getText('jira.mobile.error.permission.violation.desc')
        },
        404: {
            title: AJS.I18n.getText('jira.mobile.error.page.not.found.title'),
            desc: AJS.I18n.getText('jira.mobile.error.page.not.found.desc')
        },
        unknown: {
            title: AJS.I18n.getText('jira.mobile.error.unknown.title'),
            desc: AJS.I18n.getText('jira.mobile.error.unknown.desc')
        }
    }

    return PageView.extend({
        className: 'card error',

        events: {
            'click .error-details-link': 'showDetails'
        },

        initialize: function (options) {
            this.statusCode = options.status;
            this.errorUrl = options.url;
            this.errorMethod = options.method;
            this.errorData = options.data;
            this.header = new HeaderView({
                el: this.$el
            });
        },

        render: function () {
            var text = statusText[this.statusCode] || statusText.unknown;
            this.$el.empty();
            this.header.render();
            var params = {
                statusCode: this.statusCode,
                title: text.title,
                desc: text.desc
            };
            if (!(this.statusCode in statusText)) {
                params.details = this.errorDetails();
            }
            this.$el.append(AtlassianMobile.Templates.JIRA.layout.errorPage(params));
        },

        errorDetails: function () {
            // No i18n for error details - we need to be able to read them ;)
            var details = [
                ['URL', this.errorUrl],
                ['Method', this.errorMethod],
                ['Status Code', this.statusCode]
            ];
            if (this.errorData) {
                var hasData = false;
                if (this.errorData.errorMessages && this.errorData.errorMessages.length) {
                    details.push(['Error Messages', this.errorData.errorMessages.join('\n')]);
                    hasData = true;
                }
                if (this.errorData.errors && this.errorData.errors.length) {
                    details.push(['Errors', this.errorData.errors.join('\n')]);
                    hasData = true;
                }
                if (this.errorData.reasonKey) {
                    details.push(['Reason Key', this.errorData.reasonKey]);
                    hasData = true;
                }
                if (!hasData) {
                    details.push(['Response', JSON.stringify(this.errorData)]);
                }
            }
            return details;
        },

        showDetails: function (e) {
            e.preventDefault();
            this.$('.error-details-content').show();
            this.$('.error-details > span').hide();
        }
    });
});