/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IssueFinder {
    private final Pattern ISSUE_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");
    @Resource
    private JiraAuthenticationContext authContext;
    @Resource
    private IssueManager issueManager;
    @Resource
    private PermissionManager permissionManager;

    public MutableIssue findIssue(String issueIdOrKey) {
        if (this.isIssueId(issueIdOrKey)) {
            return this.findIssueById(Long.parseLong(issueIdOrKey));
        }
        return this.findIssueByKey(issueIdOrKey);
    }

    private MutableIssue findIssueById(@Nonnull Long id) {
        MutableIssue issue = this.issueManager.getIssueObject(id);
        return issue;
    }

    private MutableIssue findIssueByKey(@Nonnull String key) {
        key = key.toUpperCase();
        MutableIssue issue = this.issueManager.getIssueObject(key);
        return issue;
    }

    public Issue checkIssuePermission(Issue issue) {
        if (issue == null) {
            return null;
        }
        User user = this.authContext.getLoggedInUser();
        if (!this.permissionManager.hasPermission(10, issue, user)) {
            return null;
        }
        return issue;
    }

    private boolean isIssueId(String issueIdOrKey) {
        return this.ISSUE_ID_PATTERN.matcher(issueIdOrKey).matches();
    }
}

