/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mobile.rest.fields.PermissionBean;
import com.atlassian.jira.mobile.rest.fields.VoterBean;
import com.atlassian.jira.mobile.rest.fields.WatcherBean;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.lang.Pair;
import java.util.List;

public class PermissionBeanBuilder {
    private final PermissionManager permissionManager;
    private final WatcherService watcherService;
    private final VoteService voteService;
    private final IssueService issueService;
    private final ApplicationProperties jiraApplicationProperties;

    public PermissionBeanBuilder(PermissionManager permissionManager, WatcherService watcherService, VoteService voteService, IssueService issueService, ApplicationProperties jiraApplicationProperties) {
        this.permissionManager = permissionManager;
        this.watcherService = watcherService;
        this.voteService = voteService;
        this.issueService = issueService;
        this.jiraApplicationProperties = jiraApplicationProperties;
    }

    public PermissionBean build(User user, Issue issue) {
        boolean canAddComment = this.permissionManager.hasPermission(15, issue, user);
        WatcherBean watcherInfo = this.getWatcherBean(user, issue);
        VoterBean voterInfo = this.getVoterBean(user, issue);
        boolean isSelfAssignable = this.getIsSelfAssignable(user, issue);
        boolean canAssign = this.getCanAssign(user, issue);
        boolean isUnassignable = this.isUnassignedEnabled();
        return new PermissionBean(canAddComment, watcherInfo, voterInfo, isSelfAssignable, canAssign, isUnassignable);
    }

    private boolean isUnassignedEnabled() {
        boolean isEnabled = this.jiraApplicationProperties.getOption("jira.option.allowunassigned");
        return isEnabled;
    }

    private boolean getCanAssign(User user, Issue issue) {
        boolean canAssign = this.permissionManager.hasPermission(13, issue, user);
        return canAssign;
    }

    private boolean getIsSelfAssignable(User user, Issue issue) {
        if (user != null) {
            IssueService.AssignValidationResult result = this.issueService.validateAssign(user, issue.getId(), user.getName());
            boolean isEditable = this.issueService.isEditable(issue, user);
            boolean isAssignee = user.equals(issue.getAssignee());
            return result.isValid() && isEditable && !isAssignee;
        }
        return false;
    }

    private WatcherBean getWatcherBean(User user, Issue issue) {
        boolean isWatchingEnabled = this.watcherService.isWatchingEnabled();
        if (isWatchingEnabled) {
            boolean hasPermission = user != null;
            boolean isWatching = this.isWatching(user, issue);
            boolean canEditWatch = isWatchingEnabled && hasPermission;
            return new WatcherBean(isWatching, canEditWatch);
        }
        return new WatcherBean(false, false);
    }

    private VoterBean getVoterBean(User user, Issue issue) {
        if (user != null) {
            VoteService.VoteValidationResult addResult = this.voteService.validateAddVote(user, user, issue);
            VoteService.VoteValidationResult removeResult = this.voteService.validateRemoveVote(user, user, issue);
            if (addResult.isValid() || removeResult.isValid()) {
                boolean hasVoted = this.voteService.hasVoted(issue, user);
                return new VoterBean(hasVoted, true);
            }
        }
        return new VoterBean(false, false);
    }

    private boolean isWatching(User user, Issue issue) {
        List watchers = (List)((Pair)this.watcherService.getWatchers(issue, user).getReturnedValue()).second();
        return watchers.contains(user);
    }
}

