/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookSearchRequest;
import com.atlassian.webhooks.WebhookService;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public class TriggerWebHookFunctionPluginFactory
extends AbstractWorkflowPluginFactory
implements WorkflowPluginFunctionFactory {
    public static final String PARAM_FIELD_ID = "webhookId";
    public static final String TARGET_FIELD_ID = "field.webhookId";
    public static final String WEBHOOKS = "webhooks";
    public static final String SELECTED_WEBHOOK = "selectedWebhook";
    public static final String WEBHOOK_NAME = "webhookName";
    private static final Logger LOG = Logger.getLogger(TriggerWebHookFunctionPluginFactory.class);
    private final WebhookService webHookService;

    public TriggerWebHookFunctionPluginFactory(WebhookService webHookService) {
        this.webHookService = webHookService;
    }

    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        List hooks = this.webHookService.search(((WebhookSearchRequest.Builder)WebhookSearchRequest.builder().scope(WebhookScope.GLOBAL, new WebhookScope[0])).build());
        velocityParams.put(WEBHOOKS, hooks);
    }

    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String webHookId = (String)functionDescriptor.getArgs().get(TARGET_FIELD_ID);
        try {
            velocityParams.put(PARAM_FIELD_ID, Integer.parseInt(webHookId));
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Webhook id is not valid.", (Throwable)e);
            velocityParams.put(PARAM_FIELD_ID, -1);
        }
    }

    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String webHookId = (String)functionDescriptor.getArgs().get(TARGET_FIELD_ID);
        try {
            Optional webhook = this.webHookService.findById(Integer.parseInt(webHookId));
            webhook.ifPresent(value -> velocityParams.put(WEBHOOK_NAME, value.getName()));
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Webhook id is not valid.", (Throwable)e);
            velocityParams.put(WEBHOOK_NAME, "Webhook not found");
        }
    }

    public Map<String, ?> getDescriptorParams(Map<String, Object> formParams) {
        String webhookId = this.extractSingleParam(formParams, SELECTED_WEBHOOK);
        return ImmutableMap.of((Object)TARGET_FIELD_ID, (Object)webhookId);
    }
}

