/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.web;

import com.atlassian.jira.plugins.webhooks.web.OsgiServiceProvider;
import com.atlassian.jira.plugins.webhooks.web.SectionConfiguration;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.jira.webhooks.WebhookEventGroup;
import com.atlassian.jira.webhooks.WebhookEventSection;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class UriVariablesResolver {
    private final SectionConfiguration sectionConfiguration;
    private final OsgiServiceProvider osgiServiceProvider;

    @Autowired
    public UriVariablesResolver(SectionConfiguration sectionConfiguration, OsgiServiceProvider osgiServiceProvider) {
        this.sectionConfiguration = sectionConfiguration;
        this.osgiServiceProvider = osgiServiceProvider;
    }

    public Map<String, String> uriVariablesMapForTemplate() {
        Joiner joiner = Joiner.on((String)",");
        return Maps.transformValues(this.uriVariablesForWebhooks(), arg_0 -> ((Joiner)joiner).join(arg_0));
    }

    private Map<String, Set<String>> uriVariablesForWebhooks() {
        TreeMap result = Maps.newTreeMap();
        for (WebhookEvent webhook : this.getVisibleWebhooks()) {
            result.put(webhook.getId(), Sets.newHashSet());
            for (UriVariablesProvider provider : this.osgiServiceProvider.getUriVariablesProviders()) {
                if (!provider.supportedWebhookEvents().contains(webhook)) continue;
                ((Set)result.get(webhook.getId())).addAll(provider.supportedUriVariables());
            }
        }
        return result;
    }

    public List<String> getAllUriVariables() {
        return this.uriVariablesForWebhooks().values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    private Set<WebhookEvent> getVisibleWebhooks() {
        HashSet result = Sets.newHashSet();
        for (WebhookEventSection section : this.sectionConfiguration.getWebHookEventSections()) {
            for (WebhookEventGroup webHookEventGroup : section.getGroups()) {
                result.addAll(webHookEventGroup.getEvents());
            }
        }
        return result;
    }
}

