/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBean;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBeanFactory;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.context.UserContextSerializer;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public final class UserUpdatedEventVariablesProvider
implements UriVariablesProvider<UserUpdatedEvent> {
    private final UserBeanFactory userBeanFactory;
    private final UserContextSerializer userContextSerializer;

    public UserUpdatedEventVariablesProvider(UserBeanFactory userBeanFactory, UserContextSerializer userContextSerializer) {
        this.userBeanFactory = userBeanFactory;
        this.userContextSerializer = userContextSerializer;
    }

    public Map<String, Object> uriVariables(UserUpdatedEvent event) {
        UserBean user = this.userBeanFactory.createBean(ApplicationUsers.from((User)event.getUser()));
        return ImmutableMap.builder().putAll(this.userContextSerializer.getContext(user.getName(), user.getKey())).build();
    }

    public List<WebhookEvent> supportedWebhookEvents() {
        return Lists.newArrayList((Object[])new WebhookEvent[]{JiraWebhookEvent.USER_UPDATED});
    }

    public List<String> supportedUriVariables() {
        return Lists.newArrayList((Object[])new String[]{"modifiedUser.name", "modifiedUser.key"});
    }
}

