/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.context.UserContextSerializer;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public final class UserDeletedEventVariablesProvider
implements UriVariablesProvider<UserDeletedEvent> {
    private final UserKeyService userKeyService;
    private final UserContextSerializer userContextSerializer;

    public UserDeletedEventVariablesProvider(@ComponentImport UserKeyService userKeyService, UserContextSerializer userContextSerializer) {
        this.userKeyService = userKeyService;
        this.userContextSerializer = userContextSerializer;
    }

    public Map<String, Object> uriVariables(UserDeletedEvent event) {
        return ImmutableMap.builder().putAll(this.userContextSerializer.getContext(event.getUsername(), this.userKeyService.getKeyForUsername(event.getUsername()))).build();
    }

    public List<WebhookEvent> supportedWebhookEvents() {
        return Lists.newArrayList((Object[])new WebhookEvent[]{JiraWebhookEvent.USER_DELETED});
    }

    public List<String> supportedUriVariables() {
        return Lists.newArrayList((Object[])new String[]{"modifiedUser.name", "modifiedUser.key"});
    }
}

