/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.spi;

import com.atlassian.webhooks.WebhookEvent;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum JiraWebhookEvent implements WebhookEvent
{
    ISSUE_CREATED("jira:issue_created", "webhook.issue.created"),
    ISSUE_UPDATED("jira:issue_updated", "webhook.issue.updated"),
    ISSUE_DELETED("jira:issue_deleted", "webhook.issue.deleted"),
    WORKLOG_UPDATED_ISSUE_UPDATED("jira:worklog_updated", "webhook.issue.worklog.changed"),
    COMMENT_CREATED("comment_created", "webhook.comment.created"),
    COMMENT_UPDATED("comment_updated", "webhook.comment.updated"),
    COMMENT_DELETED("comment_deleted", "webhook.comment.deleted"),
    ISSUE_LINK_CREATED("issuelink_created", "webhook.issue-link.created"),
    ISSUE_LINK_DELETED("issuelink_deleted", "webhook.issue-link.removed"),
    WORKLOG_CREATED("worklog_created", "webhook.worklog.created"),
    WORKLOG_UPDATED("worklog_updated", "webhook.worklog.updated"),
    WORKLOG_DELETED("worklog_deleted", "webhook.worklog.deleted"),
    VERSION_RELEASED("jira:version_released", "webhook.version.released"),
    VERSION_UNRELEASED("jira:version_unreleased", "webhook.version.unreleased"),
    VERSION_CREATED("jira:version_created", "webhook.version.created"),
    VERSION_MOVED("jira:version_moved", "webhook.version.moved"),
    VERSION_UPDATED("jira:version_updated", "webhook.version.updated"),
    VERSION_MERGED("jira:version_merged", "webhook.version.merged"),
    VERSION_DELETED("jira:version_deleted", "webhook.version.deleted"),
    PROJECT_CREATED("project_created", "webhook.project.created"),
    PROJECT_UPDATED("project_updated", "webhook.project.updated"),
    PROJECT_DELETED("project_deleted", "webhook.project.deleted"),
    PROJECT_ARCHIVED("project_archived", "webhook.project.archived"),
    PROJECT_RESTORED("project_restored", "webhook.project.restored"),
    USER_CREATED("user_created", "webhook.user.created"),
    USER_DELETED("user_deleted", "webhook.user.deleted"),
    USER_UPDATED("user_updated", "webhook.user.updated"),
    OPTION_VOTING_CHANGED("option_voting_changed", "webhook.voting.option.changed"),
    OPTION_WATCHING_CHANGED("option_watching_changed", "webhook.watching.option.changed"),
    OPTION_UNASSIGNED_ISSUES_CHANGED("option_unassigned_issues_changed", "webhook.unassigned.issues.option.changed"),
    OPTION_SUBTASKS_CHANGED("option_subtasks_changed", "webhook.subtasks.option.changed"),
    OPTION_ATTACHMENTS_CHANGED("option_attachments_changed", "webhook.attachments.option.changed"),
    OPTION_ISSUE_LINKS_CHANGED("option_issuelinks_changed", "webhook.issuelinks.option.changed"),
    OPTION_TIME_TRACKING_CHANGED("option_timetracking_changed", "webhook.timetracking.option.changed"),
    JIRA_WEBHOOK_POST_FUNCTION("jira-webhook-post-function", "jira-webhook-post-function");

    private final String id;
    private final String i18nKey;

    private JiraWebhookEvent(String id, String i18nKey) {
        this.id = id;
        this.i18nKey = i18nKey;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getI18nKey() {
        return this.i18nKey;
    }

    public static @Nullable JiraWebhookEvent forId(@Nullable String id) {
        for (JiraWebhookEvent event : JiraWebhookEvent.values()) {
            if (!event.getId().equalsIgnoreCase(id)) continue;
            return event;
        }
        return null;
    }
}

