/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.spi;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookRequestEnricher;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class JiraWebhookBodySigner
implements WebhookRequestEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(JiraWebhookBodySigner.class);
    private static final String HEADER_NAME = "X-Hub-Signature";
    private static final String ALGORITHM = "sha256";
    private static final String ALGORITHM_HMAC_NAME = "Hmac" + "sha256".toUpperCase();
    private static final String ALGORITHM_DIGEST_PREFIX = "sha256".toLowerCase() + "=";

    public void enrich(@Nonnull WebhookInvocation webhookInvocation) {
        String secret = (String)webhookInvocation.getWebhook().getConfiguration().get("SECRET");
        if (StringUtils.isNotEmpty((CharSequence)secret)) {
            this.signBody(webhookInvocation, secret);
        } else if (secret != null) {
            LOG.warn("Secret provided to webhook signature provider is an empty string and will be ignored for invocation [{}]", (Object)webhookInvocation.getId());
        }
    }

    public int getWeight() {
        return 1000;
    }

    private void signBody(@Nonnull WebhookInvocation webhookInvocation, String secret) {
        byte[] body = webhookInvocation.getRequestBuilder().getBody();
        try {
            Mac mac = Mac.getInstance(ALGORITHM_HMAC_NAME);
            byte[] keyBytes = secret.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ALGORITHM_HMAC_NAME);
            mac.init(keySpec);
            byte[] digest = mac.doFinal(body);
            String digestString = Hex.encodeHexString((byte[])digest);
            webhookInvocation.getRequestBuilder().header(HEADER_NAME, ALGORITHM_DIGEST_PREFIX + digestString);
        }
        catch (InvalidKeyException e) {
            LOG.warn("Secret provided to webhook signature is invalid and will be ignored for invocation [{}]", (Object)webhookInvocation.getId());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Unable to initialize the signing algorithm [{}]. Webhooks will not be signed", (Object)ALGORITHM);
        }
    }
}

