/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.rest;

import com.atlassian.jira.plugins.webhooks.jql.JqlValidator;
import com.atlassian.jira.plugins.webhooks.rest.BadRequestWebException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import com.atlassian.webhooks.internal.rest.WebhooksResourceHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHelper {
    public static final int PAGE_SIZE = Integer.parseInt("10000");
    private static final int ALLOWED_URL_CONTENT_LENGTH = 2000;
    private final I18nResolver i18nResolver;
    private final JqlValidator jqlValidator;
    private final WebhooksResourceHelper webhooksResourceHelper;
    private static final Logger log = LoggerFactory.getLogger(ValidationHelper.class);

    public ValidationHelper(@ComponentImport I18nResolver i18nResolver, JqlValidator jqlValidator, WebhooksResourceHelper webhooksResourceHelper) {
        this.i18nResolver = i18nResolver;
        this.jqlValidator = jqlValidator;
        this.webhooksResourceHelper = webhooksResourceHelper;
    }

    public void validate(RestWebhook restWebhook, UriInfo uriInfo, Optional<Integer> webhookId) {
        ValidationErrors errors = new ValidationErrors();
        String webhookUrl = restWebhook.getUrl();
        if (StringUtils.isBlank((CharSequence)webhookUrl)) {
            errors.add(new ValidationErrorMessage("url", this.i18nResolver.getText("webhooks.empty.url")));
        } else {
            if (webhookUrl.length() > 2000) {
                errors.add(new ValidationErrorMessage("url", this.i18nResolver.getText("webhooks.restapi.url.length.error")));
            }
            try {
                new URI(webhookUrl.replaceAll("[\\{\\}]", ""));
            }
            catch (URISyntaxException e) {
                errors.add(new ValidationErrorMessage("url", this.i18nResolver.getText("webhooks.invalid.url.protocol")));
            }
            if (!webhookUrl.matches("^https?://.*$")) {
                errors.add(new ValidationErrorMessage("url", this.i18nResolver.getText("webhooks.invalid.url.protocol")));
            }
        }
        if (!this.jqlValidator.isJqlValid((String)restWebhook.getConfiguration().get("FILTERS"))) {
            errors.add(new ValidationErrorMessage("jql", this.i18nResolver.getText("webhooks.invalid.jql")));
        }
        if (StringUtils.isBlank((CharSequence)restWebhook.getName())) {
            errors.add(new ValidationErrorMessage("name", this.i18nResolver.getText("webhooks.empty.field", new Serializable[]{"Name"})));
        }
        if (errors.hasErrors()) {
            throw new BadRequestWebException(errors);
        }
        if (!this.validateUniqueness(uriInfo, restWebhook, webhookId)) {
            errors.add(new ValidationErrorMessage(this.i18nResolver.getText("webhooks.submit.duplicate.info")));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)errors).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateUniqueness(UriInfo uriInfo, RestWebhook webhook, Optional<Integer> webhookId) {
        long startTime = System.currentTimeMillis();
        int start = 0;
        try {
            List existingWebhooks;
            do {
                if (this.duplicateExists(webhook, webhookId, existingWebhooks = (List)this.webhooksResourceHelper.findWebhooks(uriInfo, WebhookScope.GLOBAL, webhook.getEvents().stream().toList(), true, start, PAGE_SIZE).getEntity())) {
                    boolean bl = false;
                    return bl;
                }
                start += PAGE_SIZE;
            } while (existingWebhooks.size() == PAGE_SIZE);
        }
        finally {
            long duration = System.currentTimeMillis() - startTime;
            log.info("Webhook uniqueness check completed in {} ms", (Object)duration);
        }
        return true;
    }

    private boolean duplicateExists(RestWebhook webhook, Optional<Integer> webhookId, List<RestWebhook> webhooks) {
        return webhooks.stream().anyMatch(existingWebhook -> (webhookId.isEmpty() || !existingWebhook.get((Object)"id").equals(webhookId.get())) && existingWebhook.getUrl().equals(webhook.getUrl()) && ValidationHelper.filtersMatch(webhook, existingWebhook) && Boolean.parseBoolean((String)existingWebhook.getConfiguration().get("EXCLUDE_BODY")) == Boolean.parseBoolean((String)webhook.getConfiguration().get("EXCLUDE_BODY")));
    }

    private static boolean filtersMatch(RestWebhook webhook1, RestWebhook webhook2) {
        String value1 = (String)webhook1.getConfiguration().get("FILTERS");
        String value2 = (String)webhook2.getConfiguration().get("FILTERS");
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    public static class ValidationErrors {
        @JsonProperty
        private final Set<ValidationErrorMessage> messages = new HashSet<ValidationErrorMessage>();

        public void add(ValidationErrorMessage message) {
            this.messages.add(message);
        }

        public boolean hasErrors() {
            return !this.messages.isEmpty();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ValidationErrorMessage {
        @JsonProperty
        private final String[] arguments;
        @JsonProperty
        private final String key;

        public ValidationErrorMessage(String key, String ... arguments) {
            this.key = key;
            this.arguments = arguments;
        }

        public ValidationErrorMessage(String message) {
            this.key = message;
            this.arguments = null;
        }
    }
}

