/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.plugins.webhooks.auditing.JiraWebhookAuditingHandler;
import com.atlassian.jira.plugins.webhooks.jql.JqlValidator;
import com.atlassian.jira.plugins.webhooks.rest.ValidationHelper;
import com.atlassian.jira.plugins.webhooks.rest.WebhooksRestResponseBuilder;
import com.atlassian.jira.plugins.webhooks.workflow.WorkflowUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookService;
import com.atlassian.webhooks.history.InvocationHistoryService;
import com.atlassian.webhooks.internal.rest.RestResponseBuilder;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import com.atlassian.webhooks.internal.rest.WebhooksResourceHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@AdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="webhooks")
public class GlobalWebhooksResource {
    public static final String PAGE_SIZE = "10000";
    private final WebhooksResourceHelper webhooksResourceHelper;
    private final WebhookService webhookService;
    private final I18nResolver i18nResolver;
    private final JiraWebhookAuditingHandler auditingHandler;
    private final WorkflowUtil workflowUtil;
    private final ValidationHelper validationHelper;

    @Inject
    public GlobalWebhooksResource(@ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionEnforcer permissionEnforcer, @ComponentImport WebhookService webhookService, @ComponentImport InvocationHistoryService invocationHistoryService, WorkflowUtil workflowUtil, JqlValidator jqlValidator, JiraWebhookAuditingHandler auditingHandler) {
        this.i18nResolver = i18nResolver;
        this.auditingHandler = auditingHandler;
        this.webhooksResourceHelper = new WebhooksResourceHelper(i18nResolver, (RestResponseBuilder)new WebhooksRestResponseBuilder(), () -> Optional.of(invocationHistoryService).orElseThrow(NotFoundException::new), () -> Optional.of(webhookService).orElseThrow(NotFoundException::new), scope -> permissionEnforcer.enforceAdmin());
        this.workflowUtil = workflowUtil;
        this.webhookService = webhookService;
        this.validationHelper = new ValidationHelper(i18nResolver, jqlValidator, this.webhooksResourceHelper);
    }

    @POST
    public Response createWebhook(@Context UriInfo uriInfo, RestWebhook webhook) {
        this.validationHelper.validate(webhook, uriInfo, Optional.empty());
        Response response = this.webhooksResourceHelper.createWebhook(uriInfo, WebhookScope.GLOBAL, webhook);
        Object object = response.getEntity();
        if (object instanceof RestWebhook) {
            RestWebhook restWebhook = (RestWebhook)object;
            this.auditingHandler.onWebhookCreated(restWebhook);
        }
        return response;
    }

    @DELETE
    @Path(value="/{webhookId}")
    public Response deleteWebhook(@PathParam(value="webhookId") int webhookId) {
        Object object;
        if (!this.workflowUtil.getTransitionLinkedToWebHook(webhookId).isEmpty()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.i18nResolver.getText("webhooks.delete.error.linkedtransitions")).build();
        }
        Response findResponse = this.webhooksResourceHelper.getWebhook(WebhookScope.GLOBAL, webhookId, false);
        Response deleteResponse = this.webhooksResourceHelper.deleteWebhook(WebhookScope.GLOBAL, webhookId);
        if (deleteResponse.getStatusInfo().equals(Response.Status.NO_CONTENT) && (object = findResponse.getEntity()) instanceof RestWebhook) {
            RestWebhook restWebhook = (RestWebhook)object;
            this.auditingHandler.onWebhookDeleted(restWebhook);
        }
        return deleteResponse;
    }

    @GET
    public Response findWebhooks(@Context UriInfo uriInfo, @QueryParam(value="event") List<String> events, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="10000") int limit) {
        return this.webhooksResourceHelper.findWebhooks(uriInfo, WebhookScope.GLOBAL, events, statistics, start, limit);
    }

    @GET
    @Path(value="/{webhookId}/latest")
    public Response getLatestInvocation(@PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId, @QueryParam(value="outcome") Set<String> outcomes) {
        return this.webhooksResourceHelper.getLatestInvocation(WebhookScope.GLOBAL, webhookId, eventId, outcomes);
    }

    @GET
    @Path(value="/{webhookId}/statistics")
    public Response getStatistics(@PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId) {
        return this.webhooksResourceHelper.getStatistics(WebhookScope.GLOBAL, webhookId, eventId);
    }

    @GET
    @Path(value="/{webhookId}/statistics/summary")
    public Response getStatisticsSummary(@PathParam(value="webhookId") int webhookId) {
        return this.webhooksResourceHelper.getStatisticsSummary(WebhookScope.GLOBAL, webhookId);
    }

    @GET
    @Path(value="/{webhookId}")
    public Response getWebhook(@PathParam(value="webhookId") int webhookId, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics) {
        return this.webhooksResourceHelper.getWebhook(WebhookScope.GLOBAL, webhookId, statistics);
    }

    @PUT
    @Path(value="/{webhookId}")
    public Response updateWebhook(@Context UriInfo uriInfo, @PathParam(value="webhookId") int webhookId, RestWebhook webhook) {
        this.validationHelper.validate(webhook, uriInfo, Optional.of(webhookId));
        Response findResponse = this.webhooksResourceHelper.getWebhook(WebhookScope.GLOBAL, webhookId, false);
        Response response = this.webhooksResourceHelper.update(WebhookScope.GLOBAL, webhookId, webhook);
        Object object = response.getEntity();
        if (object instanceof RestWebhook) {
            RestWebhook newWebhook = (RestWebhook)object;
            object = findResponse.getEntity();
            if (object instanceof RestWebhook) {
                RestWebhook oldWebhook = (RestWebhook)object;
                this.auditingHandler.onWebhookModified(oldWebhook, newWebhook);
            }
        }
        return response;
    }

    @GET
    @Path(value="{id}/transitions")
    public Response getTransitions(@PathParam(value="id") int id, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics) {
        Optional webhook = this.webhookService.findById(id);
        if (webhook.isPresent()) {
            return Response.ok(this.workflowUtil.getTransitionLinkedToWebHook(id)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

