/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.jql;

import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Either;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class JqlValidator {
    private final JqlQueryParser jqlQueryParser;

    public JqlValidator(@ComponentImport JqlQueryParser jqlQueryParser) {
        this.jqlQueryParser = jqlQueryParser;
    }

    public boolean isJqlValid(String jql) {
        if (StringUtils.isNotBlank((CharSequence)jql)) {
            Either<JqlParseException, String> jqlValid = this.parseJql(jql);
            return jqlValid.isRight();
        }
        return true;
    }

    private Either<JqlParseException, String> parseJql(String jql) {
        try {
            this.jqlQueryParser.parseQuery(jql);
            return Either.right((Object)jql);
        }
        catch (JqlParseException e) {
            return Either.left((Object)((Object)e));
        }
    }
}

