/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.util.NaturalOrderStringComparator;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;

public class RemoteIssueLinkComparator
implements Comparator<RemoteIssueLink> {
    private static final String ATLASSIAN_APPLICATION_TYPE_PREFIX = "com.atlassian.";
    private static final Comparator<Object> NULL_HIGH_COMPARATOR = ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.NATURAL_COMPARATOR);
    private final String defaultRelationship;

    public RemoteIssueLinkComparator(String defaultRelationship) {
        this.defaultRelationship = defaultRelationship;
    }

    @Override
    public int compare(RemoteIssueLink o1, RemoteIssueLink o2) {
        String titleSummary2;
        int result = this.getRelationship(o1.getRelationship()).compareToIgnoreCase(this.getRelationship(o2.getRelationship()));
        if (result != 0) {
            return result;
        }
        if (RemoteIssueLink.APPLICATION_TYPE_JIRA.equals(o1.getApplicationType()) && !RemoteIssueLink.APPLICATION_TYPE_JIRA.equals(o2.getApplicationType())) {
            return -1;
        }
        if (!RemoteIssueLink.APPLICATION_TYPE_JIRA.equals(o1.getApplicationType()) && RemoteIssueLink.APPLICATION_TYPE_JIRA.equals(o2.getApplicationType())) {
            return 1;
        }
        if (StringUtils.startsWith((String)o1.getApplicationType(), (String)ATLASSIAN_APPLICATION_TYPE_PREFIX) && !StringUtils.startsWith((String)o2.getApplicationType(), (String)ATLASSIAN_APPLICATION_TYPE_PREFIX)) {
            return -1;
        }
        if (!StringUtils.startsWith((String)o1.getApplicationType(), (String)ATLASSIAN_APPLICATION_TYPE_PREFIX) && StringUtils.startsWith((String)o2.getApplicationType(), (String)ATLASSIAN_APPLICATION_TYPE_PREFIX)) {
            return 1;
        }
        result = NULL_HIGH_COMPARATOR.compare(o1.getApplicationType(), o2.getApplicationType());
        if (result != 0) {
            return result;
        }
        result = NULL_HIGH_COMPARATOR.compare(o1.getApplicationName(), o2.getApplicationName());
        if (result != 0) {
            return result;
        }
        String titleSummary1 = StringUtils.defaultString((String)o1.getTitle()) + " " + StringUtils.defaultString((String)o1.getSummary());
        if (!titleSummary1.equals(titleSummary2 = StringUtils.defaultString((String)o2.getTitle()) + " " + StringUtils.defaultString((String)o2.getSummary()))) {
            return NaturalOrderStringComparator.CASE_INSENSITIVE_ORDER.compare(titleSummary1, titleSummary2);
        }
        return 0;
    }

    private String getRelationship(String relationship) {
        return StringUtils.defaultIfEmpty((String)relationship, (String)this.defaultRelationship);
    }
}

