/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class GlobalIdFactory {
    private static final String ENCODING = "UTF-8";

    public static String encode(List<String> keys, Map<String, String> values) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (String key : keys) {
            params.add(new BasicNameValuePair(key, values.get(key)));
        }
        return URLEncodedUtils.format(params, (String)ENCODING);
    }

    public static Map<String, String> decode(String globalId, List<String> keys) {
        ArrayList params = new ArrayList();
        Scanner scanner = new Scanner(globalId);
        try {
            URLEncodedUtils.parse(params, (Scanner)scanner, (String)ENCODING);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("globalId is invalid, expected format is: " + GlobalIdFactory.getExpectedFormat(keys) + ", found: " + globalId, e);
        }
        if (params.size() != keys.size()) {
            throw new IllegalArgumentException("globalId is invalid, expected format is: " + GlobalIdFactory.getExpectedFormat(keys) + ", found: " + globalId);
        }
        HashMap<String, String> result = new HashMap<String, String>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            NameValuePair param = (NameValuePair)params.get(i);
            if (!param.getName().equals(keys.get(i))) {
                throw new IllegalArgumentException("globalId is invalid, expected format is: " + GlobalIdFactory.getExpectedFormat(keys) + ", found: " + globalId);
            }
            result.put(param.getName(), param.getValue());
        }
        return result;
    }

    private static String getExpectedFormat(List<String> keys) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : keys) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(key).append("=<").append(key).append(">");
        }
        return sb.toString();
    }
}

