/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.issuelink.AbstractIssueLinkRenderer;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultIssueLinkRenderer
extends AbstractIssueLinkRenderer {
    public static final String DEFAULT_ICON_URL = "/images/icons/generic_link_16.png";

    public Map<String, Object> getInitialContext(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        I18nHelper i18n = this.getValue(context, "i18n", I18nHelper.class);
        String baseUrl = this.getValue(context, "baseurl", String.class);
        return DefaultIssueLinkRenderer.createContext(remoteIssueLink, i18n, baseUrl);
    }

    private <T> T getValue(Map<String, Object> context, String key, Class<T> klass) {
        Object obj = context.get(key);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Expected '%s' to exist in the context map", key));
        }
        return klass.cast(obj);
    }

    private static Map<String, Object> createContext(RemoteIssueLink remoteIssueLink, I18nHelper i18n, String baseUrl) {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        String tooltip = DefaultIssueLinkRenderer.getTooltip(remoteIssueLink);
        String iconUrl = StringUtils.defaultIfEmpty((String)remoteIssueLink.getIconUrl(), (String)(baseUrl + DEFAULT_ICON_URL));
        String iconTooltip = DefaultIssueLinkRenderer.getIconTooltip(remoteIssueLink, i18n);
        ImmutableMap statusCategory = null;
        if (remoteIssueLink.hasStatusCategory()) {
            ImmutableMap.Builder sc = ImmutableMap.builder();
            DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)sc, "key", remoteIssueLink.getStatusCategoryKey());
            DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)sc, "colorName", remoteIssueLink.getStatusCategoryColorName());
            statusCategory = sc.build();
        }
        ImmutableMap.Builder s = ImmutableMap.builder();
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)s, "name", remoteIssueLink.getStatusName());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)s, "description", remoteIssueLink.getStatusDescription());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)s, "statusCategory", statusCategory);
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)s, "iconUrl", remoteIssueLink.getStatusIconUrl());
        ImmutableMap status = s.build();
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "id", remoteIssueLink.getId());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "url", remoteIssueLink.getUrl());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "title", remoteIssueLink.getTitle());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "iconUrl", iconUrl);
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "iconTooltip", iconTooltip);
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "tooltip", tooltip);
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "summary", remoteIssueLink.getSummary());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "statusIconUrl", remoteIssueLink.getStatusIconUrl());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "statusIconTooltip", remoteIssueLink.getStatusIconTitle());
        if (status.size() > 0) {
            DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "status", status);
        }
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "statusIconLink", remoteIssueLink.getStatusIconLink());
        DefaultIssueLinkRenderer.putMap((ImmutableMap.Builder<String, Object>)contextBuilder, "resolved", remoteIssueLink.isResolved() == null ? false : remoteIssueLink.isResolved());
        return contextBuilder.build();
    }

    private static void putMap(ImmutableMap.Builder<String, Object> mapBuilder, String key, Object value) {
        if (value != null) {
            mapBuilder.put((Object)key, value);
        }
    }

    private static String getIconTooltip(RemoteIssueLink remoteIssueLink, I18nHelper i18n) {
        boolean hasApplicationName = StringUtils.isNotEmpty((String)remoteIssueLink.getApplicationName());
        boolean hasIconText = StringUtils.isNotEmpty((String)remoteIssueLink.getIconTitle());
        if (hasApplicationName && hasIconText) {
            return "[" + remoteIssueLink.getApplicationName() + "] " + remoteIssueLink.getIconTitle();
        }
        if (hasApplicationName) {
            return "[" + remoteIssueLink.getApplicationName() + "]";
        }
        if (hasIconText) {
            return remoteIssueLink.getIconTitle();
        }
        return i18n.getText("issuelinking.remote.link.weblink.title");
    }

    private static String getTooltip(RemoteIssueLink remoteIssueLink) {
        boolean hasApplicationName = StringUtils.isNotEmpty((String)remoteIssueLink.getApplicationName());
        boolean hasSummary = StringUtils.isNotEmpty((String)remoteIssueLink.getSummary());
        if (hasApplicationName && hasSummary) {
            return "[" + remoteIssueLink.getApplicationName() + "] " + remoteIssueLink.getTitle() + ": " + remoteIssueLink.getSummary();
        }
        if (hasApplicationName) {
            return "[" + remoteIssueLink.getApplicationName() + "] " + remoteIssueLink.getTitle();
        }
        if (hasSummary) {
            return remoteIssueLink.getTitle() + ": " + remoteIssueLink.getSummary();
        }
        return remoteIssueLink.getTitle();
    }
}

