/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.plugin.viewissue.DateBlockField;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import webwork.action.Action;

public class DateBlockContextProvider
implements CacheableContextProvider {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final DateTimeFormatter dateTimeFormater;
    private final DateFieldFormat dateFieldFormat;

    public DateBlockContextProvider(FieldVisibilityManager fieldVisibilityManager, JiraAuthenticationContext authenticationContext, DateTimeFormatterFactory dateTimeFormatterFactory, FieldScreenRendererFactory fieldScreenRendererFactory, DateFieldFormat dateFieldFormat) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.dateFieldFormat = dateFieldFormat;
        this.dateTimeFormater = dateTimeFormatterFactory.formatter().forLoggedInUser();
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        Action action = (Action)context.get("action");
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        ArrayList dates = Lists.newArrayList();
        Timestamp dueDate = issue.getDueDate();
        if (dueDate != null && !this.fieldVisibilityManager.isFieldHidden("duedate", issue)) {
            dates.add(new DateField("due-date", "issue.field.due", dueDate));
        }
        dates.add(new DateTimeField("create-date", "issue.field.created", issue.getCreated()));
        dates.add(new DateTimeField("updated-date", "issue.field.updated", issue.getUpdated()));
        Timestamp resolutionDate = issue.getResolutionDate();
        if (resolutionDate != null) {
            dates.add(new DateTimeField("resolved-date", "issue.field.resolution.date", resolutionDate));
        }
        dates.addAll(this.getDateCustomFields(issue, action));
        paramsBuilder.add((Object)"dates", (Object)dates);
        return paramsBuilder.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        User user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private List<DateBlockField> getDateCustomFields(Issue issue, Action action) {
        MapBuilder paramBuilder = MapBuilder.newBuilder();
        paramBuilder.add((Object)"view_issue", (Object)true);
        Map params = paramBuilder.toMap();
        FieldScreenRenderer screenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isCustomDateField());
        List dateRenderItems = screenRenderer.getAllScreenRenderItems();
        ArrayList customfields = Lists.newArrayListWithExpectedSize((int)dateRenderItems.size());
        for (FieldScreenRenderLayoutItem renderItem : dateRenderItems) {
            CustomField customField = (CustomField)renderItem.getOrderableField();
            String displayHtml = customField.getViewHtml(renderItem.getFieldLayoutItem(), action, issue, params);
            String fieldType = customField.getCustomFieldType().getDescriptor().getKey();
            String fieldTypeCompleteKey = customField.getCustomFieldType().getDescriptor().getCompleteKey();
            customfields.add(new DateBlockField(customField.getId() + "-val", customField.getName(), null, displayHtml, null, null, fieldType, fieldTypeCompleteKey));
        }
        return customfields;
    }

    protected String getI18nText(String key) {
        return this.authenticationContext.getI18nHelper().getText(key);
    }

    protected String formatDate(Date date) {
        return StringEscapeUtils.escapeHtml((String)this.dateFieldFormat.format(date));
    }

    protected String formatDateIso8601(Date date) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormater.withSystemZone().withStyle(DateTimeStyle.ISO_8601_DATE).format(date));
    }

    private String formatDateTime(Date dateTime) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormater.format(dateTime));
    }

    protected String formatDateTimeIso8601(Date dateTime) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormater.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(dateTime));
    }

    protected String formatDateTimeTitle(Date dateTime) {
        return StringEscapeUtils.escapeHtml((String)this.dateTimeFormater.withStyle(DateTimeStyle.COMPLETE).format(dateTime));
    }

    class Iso8601Visitor
    extends CustomFieldVisitor {
        Iso8601Visitor(CustomField field, Issue issue) {
            super(field, issue);
        }

        public String visitDate(DateCFType dateCustomFieldType) {
            return DateBlockContextProvider.this.formatDateIso8601(this.getDate((CustomFieldType)dateCustomFieldType));
        }

        public String visitDateTime(DateTimeCFType dateTimeCFType) {
            return DateBlockContextProvider.this.formatDateTimeIso8601(this.getDate((CustomFieldType)dateTimeCFType));
        }
    }

    class TitleVisitor
    extends CustomFieldVisitor {
        TitleVisitor(CustomField field, Issue issue) {
            super(field, issue);
        }

        public String visitDate(DateCFType dateCustomFieldType) {
            return DateBlockContextProvider.this.formatDate(this.getDate((CustomFieldType)dateCustomFieldType));
        }

        public String visitDateTime(DateTimeCFType dateTimeCFType) {
            return DateBlockContextProvider.this.formatDateTimeTitle(this.getDate((CustomFieldType)dateTimeCFType));
        }
    }

    abstract class CustomFieldVisitor
    implements AbstractCustomFieldType.Visitor<String>,
    DateCFType.Visitor<String>,
    DateTimeCFType.Visitor<String> {
        private final CustomField field;
        private final Issue issue;

        CustomFieldVisitor(CustomField field, Issue issue) {
            this.field = field;
            this.issue = issue;
        }

        public String visit(AbstractCustomFieldType customFieldType) {
            return null;
        }

        Date getDate(CustomFieldType dateTimeCFType) {
            return (Date)dateTimeCFType.getValueFromIssue(this.field, this.issue);
        }
    }

    class DateTimeField
    extends DateBlockField {
        public DateTimeField(String id, String key, Timestamp dateTime) {
            super(id, DateBlockContextProvider.this.getI18nText(key), "user-tz", DateBlockContextProvider.this.formatDateTime(dateTime), DateBlockContextProvider.this.formatDateTimeIso8601(dateTime), DateBlockContextProvider.this.formatDateTimeTitle(dateTime), "datetime", null);
        }
    }

    class DateField
    extends DateBlockField {
        DateField(String id, String key, Timestamp date) {
            super(id, DateBlockContextProvider.this.getI18nText(key), null, DateBlockContextProvider.this.formatDate(date), DateBlockContextProvider.this.formatDateIso8601(date), DateBlockContextProvider.this.formatDate(date), "datepicker", null);
        }
    }
}

