/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentSortingOrderOptionsFactory
implements SimpleLinkFactory {
    private final VelocityRequestContextFactory requestContextFactory;
    private final JiraAuthenticationContext authenticationContext;

    public AttachmentSortingOrderOptionsFactory(VelocityRequestContextFactory requestContextFactory, JiraAuthenticationContext authenticationContext) {
        this.requestContextFactory = requestContextFactory;
        this.authenticationContext = authenticationContext;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        Issue issue = (Issue)params.get("issue");
        VelocityRequestSession session = requestContext.getSession();
        String baseUrl = requestContext.getBaseUrl();
        String sortingOrder = (String)session.getAttribute("jira.issue.attachment.order");
        boolean sortedAscending = "asc".equals(sortingOrder) || StringUtils.isBlank((String)sortingOrder);
        SimpleLinkImpl allLink = new SimpleLinkImpl("attachment-sort-direction-asc", i18n.getText("viewissue.attachments.sort.direction.asc"), i18n.getText("viewissue.attachments.sort.direction.asc"), null, sortedAscending ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?attachmentOrder=asc#attachmentmodule", null);
        SimpleLinkImpl openLink = new SimpleLinkImpl("attachment-sort-direction-desc", i18n.getText("viewissue.attachments.sort.direction.desc"), i18n.getText("viewissue.attachments.sort.direction.desc"), null, !sortedAscending ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?attachmentOrder=desc#attachmentmodule", null);
        return CollectionBuilder.list((Object[])new SimpleLink[]{allLink, openLink});
    }
}

