/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.VersionRestClient;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.VersionRelatedIssuesCount;
import com.atlassian.jira.rest.client.api.domain.input.VersionInput;
import com.atlassian.jira.rest.client.api.domain.input.VersionPosition;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import com.atlassian.jira.rest.client.internal.json.VersionRelatedIssueCountJsonParser;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.VersionInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.VersionPositionInputGenerator;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousVersionRestClient
extends AbstractAsynchronousRestClient
implements VersionRestClient {
    private final URI versionRootUri;

    public AsynchronousVersionRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.versionRootUri = UriBuilder.fromUri((URI)baseUri).path("version").build(new Object[0]);
    }

    public Promise<Version> getVersion(URI versionUri) {
        return this.getAndParse(versionUri, new VersionJsonParser());
    }

    public Promise<Version> createVersion(VersionInput versionInput) {
        return this.postAndParse(this.versionRootUri, versionInput, new VersionInputJsonGenerator(), new VersionJsonParser());
    }

    public Promise<Version> updateVersion(URI versionUri, VersionInput versionInput) {
        return this.putAndParse(versionUri, versionInput, new VersionInputJsonGenerator(), new VersionJsonParser());
    }

    public Promise<Void> removeVersion(URI versionUri, @Nullable URI moveFixIssuesToVersionUri, @Nullable URI moveAffectedIssuesToVersionUri) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)versionUri);
        if (moveFixIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveFixIssuesTo", new Object[]{moveFixIssuesToVersionUri});
        }
        if (moveAffectedIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveAffectedIssuesTo", new Object[]{moveAffectedIssuesToVersionUri});
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    public Promise<VersionRelatedIssuesCount> getVersionRelatedIssuesCount(URI versionUri) {
        URI relatedIssueCountsUri = UriBuilder.fromUri((URI)versionUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new VersionRelatedIssueCountJsonParser());
    }

    public Promise<Integer> getNumUnresolvedIssues(URI versionUri) {
        URI unresolvedIssueCountUri = UriBuilder.fromUri((URI)versionUri).path("unresolvedIssueCount").build(new Object[0]);
        return this.getAndParse(unresolvedIssueCountUri, new JsonObjectParser<Integer>(this){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issuesUnresolvedCount");
            }
        });
    }

    public Promise<Version> moveVersionAfter(URI versionUri, URI afterVersionUri) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, afterVersionUri, new JsonGenerator<URI>(this){

            @Override
            public JSONObject generate(URI uri) throws JSONException {
                JSONObject res = new JSONObject();
                res.put("after", (Object)uri);
                return res;
            }
        }, new VersionJsonParser());
    }

    public Promise<Version> moveVersion(URI versionUri, VersionPosition versionPosition) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, versionPosition, new VersionPositionInputGenerator(), new VersionJsonParser());
    }

    private URI getMoveVersionUri(URI versionUri) {
        return UriBuilder.fromUri((URI)versionUri).path("move").build(new Object[0]);
    }
}

