/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.jira.rest.client.api.EmailRestClient;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.Promise;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;

public class AsynchronousEmailRestClient
implements EmailRestClient {
    final URI baseUri;
    final HttpClient client;
    final String authToken;

    public AsynchronousEmailRestClient(URI baseUri, HttpClient client) {
        this.client = client;
        this.baseUri = baseUri;
        this.authToken = "A";
    }

    @VisibleForTesting
    public static String constructEmail(String destEmail, String subject, String body) {
        StringBuilder buff = new StringBuilder();
        buff.append("Received: from smtp-out.example.com (123.45.67.89) by\nin.example.com (87.65.43.210); Wed, 2 Mar 2011 11:39:39 -0800\nFrom: \"test\" <test@example.com>\nTo: " + destEmail + "\nSubject: " + subject + "\nMessage-ID: <97DCB304-C529-4779-BEBC-FC8357FCC4D2@example.com>\nAccept-Language: en-US\nContent-Language: en-US\nMIME-Version: 1.0\nContent-Type: text/plain; charset=\"us-ascii\"\n\n" + body);
        return buff.toString();
    }

    public Promise<Response> postMessage(String destEmail, String subject, String body) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("email").path("incoming").queryParam("email", new Object[]{destEmail});
        return ((Request.Builder)((Request.Builder)this.client.newRequest(uriBuilder.build(new Object[0])).setContentType("text/plain")).setEntity(AsynchronousEmailRestClient.constructEmail(destEmail, subject, body))).post();
    }
}

