/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.GroupRestClient;
import com.atlassian.jira.rest.client.api.domain.Group;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.GroupsJsonParser;
import io.atlassian.util.concurrent.Promise;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import javax.annotation.Nullable;

public class AsynchronousGroupRestClient
extends AbstractAsynchronousRestClient
implements GroupRestClient {
    private static final String GROUPS_URI_PREFIX = "groups";
    private static final String PICKER_URI_PREFIX = "picker";
    private static final String QUERY_ATTRIBUTE = "query";
    private static final String EXCLUDE_ATTRIBUTE = "exclude";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final String USERNAME_ATTRIBUTE = "userName";
    private final GroupsJsonParser groupsJsonParser = new GroupsJsonParser();
    private final URI baseUri;

    public AsynchronousGroupRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    public Promise<Iterable<Group>> findGroups() {
        return this.findGroups(null, null, null, null);
    }

    public Promise<Iterable<Group>> findGroups(@Nullable String query, @Nullable String exclude, @Nullable Integer maxResults, @Nullable String userName) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path(GROUPS_URI_PREFIX).path(PICKER_URI_PREFIX);
        this.addOptionalQueryParam(uriBuilder, QUERY_ATTRIBUTE, query);
        this.addOptionalQueryParam(uriBuilder, EXCLUDE_ATTRIBUTE, exclude);
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        this.addOptionalQueryParam(uriBuilder, USERNAME_ATTRIBUTE, userName);
        URI groupsUri = uriBuilder.build(new Object[0]);
        return this.getAndParse(groupsUri, this.groupsJsonParser);
    }

    private void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object value) {
        if (value != null) {
            uriBuilder.queryParam(key, new Object[]{value});
        }
    }
}

