/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.permission;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.rest.api.permission.PermissionHolderTypeMapping;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public enum PermissionSchemeExpandParam {
    permissions(new JiraPermissionHolderType[0]),
    user(JiraPermissionHolderType.USER),
    group(JiraPermissionHolderType.GROUP),
    projectRole(JiraPermissionHolderType.PROJECT_ROLE),
    field(JiraPermissionHolderType.GROUP_CUSTOM_FIELD, JiraPermissionHolderType.USER_CUSTOM_FIELD),
    all(JiraPermissionHolderType.USER, JiraPermissionHolderType.GROUP, JiraPermissionHolderType.PROJECT_ROLE, JiraPermissionHolderType.GROUP_CUSTOM_FIELD, JiraPermissionHolderType.USER_CUSTOM_FIELD);

    public static final String PERMISSION_SCHEME_EXPAND_PARAMS;
    public static final String PERMISSION_GRANTS_ENVELOPE_EXPAND_PARAMS;
    private final Set<PermissionHolderType> expandedTypes;

    private PermissionSchemeExpandParam(JiraPermissionHolderType ... expandedTypes) {
        this.expandedTypes = ImmutableSet.copyOf((Object[])expandedTypes);
    }

    public boolean expandsType(PermissionHolderType type) {
        return this.expandedTypes.contains(type);
    }

    @Nullable
    public static String expandForType(String type) {
        Optional<PermissionHolderType> holderType = PermissionHolderTypeMapping.fromRestType(type);
        if (holderType.isPresent()) {
            for (PermissionSchemeExpandParam permissionSchemeExpandParam : PermissionSchemeExpandParam.values()) {
                if (!permissionSchemeExpandParam.expandsType(holderType.get())) continue;
                return permissionSchemeExpandParam.toString();
            }
        }
        return null;
    }

    static {
        PERMISSION_SCHEME_EXPAND_PARAMS = Joiner.on((char)',').join(Arrays.asList(PermissionSchemeExpandParam.values()));
        PERMISSION_GRANTS_ENVELOPE_EXPAND_PARAMS = Joiner.on((char)',').join((Iterable)ImmutableList.of((Object)((Object)user), (Object)((Object)group), (Object)((Object)projectRole), (Object)((Object)field), (Object)((Object)all)));
    }
}

