/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.permission;

import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonProperty;

public final class PermissionHolderBean {
    @JsonProperty
    private String type;
    @JsonProperty
    private String parameter;
    @JsonProperty
    private UserJsonBean user;
    @JsonProperty
    private GroupJsonBean group;
    @JsonProperty
    private FieldBean field;
    @JsonProperty
    private ProjectRoleBean projectRole;
    private boolean isInput = false;

    public static PermissionHolderBean holderBean(String type, String parameter) {
        return new PermissionHolderBean(type, parameter, null, null, null, null);
    }

    @Deprecated
    public PermissionHolderBean() {
    }

    private PermissionHolderBean(String type, String parameter, UserJsonBean user, GroupJsonBean group, FieldBean field, ProjectRoleBean projectRole) {
        this.type = type;
        this.parameter = parameter;
        this.user = user;
        this.group = group;
        this.field = field;
        this.projectRole = projectRole;
    }

    @JsonProperty
    public String getExpand() {
        return this.isInput ? null : PermissionSchemeExpandParam.expandForType(this.type);
    }

    public PermissionHolderBean input() {
        this.isInput = true;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public UserJsonBean getUser() {
        return this.user;
    }

    public void setUser(UserJsonBean user) {
        this.user = user;
    }

    public GroupJsonBean getGroup() {
        return this.group;
    }

    public void setGroup(GroupJsonBean group) {
        this.group = group;
    }

    public FieldBean getField() {
        return this.field;
    }

    public void setField(FieldBean field) {
        this.field = field;
    }

    public ProjectRoleBean getProjectRole() {
        return this.projectRole;
    }

    public void setProjectRole(ProjectRoleBean projectRole) {
        this.projectRole = projectRole;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PermissionHolderBean data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionHolderBean that = (PermissionHolderBean)o;
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.parameter, (Object)that.parameter) && Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.field, (Object)that.field) && Objects.equal((Object)this.projectRole, (Object)that.projectRole);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.parameter, this.user, this.group, this.field, this.projectRole});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("parameter", (Object)this.parameter).add("user", (Object)this.user).add("group", (Object)this.group).add("field", (Object)this.field).add("projectRole", (Object)this.projectRole).toString();
    }

    public static final class Builder {
        private String type;
        private String parameter;
        private UserJsonBean user;
        private GroupJsonBean group;
        private FieldBean field;
        private ProjectRoleBean projectRole;

        private Builder() {
        }

        private Builder(PermissionHolderBean initialData) {
            this.type = initialData.type;
            this.parameter = initialData.parameter;
            this.user = initialData.user;
            this.group = initialData.group;
            this.field = initialData.field;
            this.projectRole = initialData.projectRole;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setParameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public Builder setUser(UserJsonBean user) {
            this.user = user;
            return this;
        }

        public Builder setGroup(GroupJsonBean group) {
            this.group = group;
            return this;
        }

        public Builder setField(FieldBean field) {
            this.field = field;
            return this;
        }

        public Builder setProjectRole(ProjectRoleBean projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public PermissionHolderBean build() {
            return new PermissionHolderBean(this.type, this.parameter, this.user, this.group, this.field, this.projectRole);
        }
    }
}

